/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Division;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.joda.time.LocalDateTime;

@ApiModel(description="Defines a period of time to perform a specific action.  Each schedule must be associated with one or more schedule groups to be used.")
public class Schedule
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private LocalDateTime start = null;
    private LocalDateTime end = null;
    private String rrule = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Schedule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the entity.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Schedule division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public Schedule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource's description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Schedule version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version of the resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Schedule dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Schedule dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public Schedule modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the resource.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Schedule createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the resource.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="Indicates if the resource is active, inactive, or deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public Schedule modifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that last modified the resource.")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    public void setModifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
    }

    public Schedule createdByApp(String createdByApp) {
        this.createdByApp = createdByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that created the resource.")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public void setCreatedByApp(String createdByApp) {
        this.createdByApp = createdByApp;
    }

    public Schedule start(LocalDateTime start) {
        this.start = start;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date time is represented as an ISO-8601 string without a timezone. For example: yyyy-MM-ddTHH:mm:ss.SSS")
    @JsonProperty(value="start")
    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public Schedule end(LocalDateTime end) {
        this.end = end;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date time is represented as an ISO-8601 string without a timezone. For example: yyyy-MM-ddTHH:mm:ss.SSS")
    @JsonProperty(value="end")
    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public Schedule rrule(String rrule) {
        this.rrule = rrule;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="An iCal Recurrence Rule (RRULE) string.")
    @JsonProperty(value="rrule")
    public String getRrule() {
        return this.rrule;
    }

    public void setRrule(String rrule) {
        this.rrule = rrule;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schedule schedule = (Schedule)o;
        return Objects.equals(this.id, schedule.id) && Objects.equals(this.name, schedule.name) && Objects.equals(this.division, schedule.division) && Objects.equals(this.description, schedule.description) && Objects.equals(this.version, schedule.version) && Objects.equals(this.dateCreated, schedule.dateCreated) && Objects.equals(this.dateModified, schedule.dateModified) && Objects.equals(this.modifiedBy, schedule.modifiedBy) && Objects.equals(this.createdBy, schedule.createdBy) && Objects.equals((Object)this.state, (Object)schedule.state) && Objects.equals(this.modifiedByApp, schedule.modifiedByApp) && Objects.equals(this.createdByApp, schedule.createdByApp) && Objects.equals(this.start, schedule.start) && Objects.equals(this.end, schedule.end) && Objects.equals(this.rrule, schedule.rrule) && Objects.equals(this.selfUri, schedule.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.start, this.end, this.rrule, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Schedule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    rrule: ").append(this.toIndentedString(this.rrule)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

