/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class DataSchema
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer version = null;
    private List<AppliesToEnum> appliesTo = new ArrayList<AppliesToEnum>();
    private Boolean enabled = null;
    private DomainEntityRef createdBy = null;
    private Date dateCreated = null;
    private JsonSchemaDocument jsonSchema = null;
    private String selfUri = null;

    public DataSchema id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the schema.  Only required if a schema is used for custom fields during external entity creation or updates.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DataSchema name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSchema version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The schema's version, a positive integer. Required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DataSchema appliesTo(List<AppliesToEnum> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    @ApiModelProperty(example="null", value="One of \"CONTACT\" or \"EXTERNAL_ORGANIZATION\".  Indicates the built-in entity type to which this schema applies.")
    @JsonProperty(value="appliesTo")
    public List<AppliesToEnum> getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(List<AppliesToEnum> appliesTo) {
        this.appliesTo = appliesTo;
    }

    public DataSchema enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="The schema's enabled/disabled status. A disabled schema cannot be assigned to any other entities, but the data on those entities from the schema still exists.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DataSchema createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the user that created this schema.")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="The date and time this schema was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public DataSchema jsonSchema(JsonSchemaDocument jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A JSON schema defining the extension to the built-in entity type.")
    @JsonProperty(value="jsonSchema")
    public JsonSchemaDocument getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(JsonSchemaDocument jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSchema dataSchema = (DataSchema)o;
        return Objects.equals(this.id, dataSchema.id) && Objects.equals(this.name, dataSchema.name) && Objects.equals(this.version, dataSchema.version) && Objects.equals(this.appliesTo, dataSchema.appliesTo) && Objects.equals(this.enabled, dataSchema.enabled) && Objects.equals(this.createdBy, dataSchema.createdBy) && Objects.equals(this.dateCreated, dataSchema.dateCreated) && Objects.equals(this.jsonSchema, dataSchema.jsonSchema) && Objects.equals(this.selfUri, dataSchema.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.version, this.appliesTo, this.enabled, this.createdBy, this.dateCreated, this.jsonSchema, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataSchema {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    appliesTo: ").append(this.toIndentedString(this.appliesTo)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    jsonSchema: ").append(this.toIndentedString(this.jsonSchema)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AppliesToEnumDeserializer.class)
    public static enum AppliesToEnum {
        CONTACT("CONTACT"),
        EXTERNAL_ORGANIZATION("EXTERNAL_ORGANIZATION");

        private String value;

        private AppliesToEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AppliesToEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AppliesToEnum value : AppliesToEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AppliesToEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AppliesToEnumDeserializer
    extends StdDeserializer<AppliesToEnum> {
        public AppliesToEnumDeserializer() {
            super(AppliesToEnumDeserializer.class);
        }

        public AppliesToEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AppliesToEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

