/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetGeolocationsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserGeolocationRequest;
import com.mypurecloud.sdk.v2.api.request.PatchGeolocationsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchUserGeolocationRequest;
import com.mypurecloud.sdk.v2.model.Geolocation;
import com.mypurecloud.sdk.v2.model.GeolocationSettings;
import java.io.IOException;

public class GeolocationApi {
    private final ApiClient pcapiClient;

    public GeolocationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GeolocationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public GeolocationSettings getGeolocationsSettings() throws IOException, ApiException {
        return this.getGeolocationsSettings(this.createGetGeolocationsSettingsRequest());
    }

    public ApiResponse<GeolocationSettings> getGeolocationsSettingsWithHttpInfo() throws IOException {
        return this.getGeolocationsSettings(this.createGetGeolocationsSettingsRequest().withHttpInfo());
    }

    private GetGeolocationsSettingsRequest createGetGeolocationsSettingsRequest() {
        return GetGeolocationsSettingsRequest.builder().build();
    }

    public GeolocationSettings getGeolocationsSettings(GetGeolocationsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GeolocationSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GeolocationSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GeolocationSettings> getGeolocationsSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GeolocationSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Geolocation getUserGeolocation(String userId, String clientId) throws IOException, ApiException {
        return this.getUserGeolocation(this.createGetUserGeolocationRequest(userId, clientId));
    }

    public ApiResponse<Geolocation> getUserGeolocationWithHttpInfo(String userId, String clientId) throws IOException {
        return this.getUserGeolocation(this.createGetUserGeolocationRequest(userId, clientId).withHttpInfo());
    }

    private GetUserGeolocationRequest createGetUserGeolocationRequest(String userId, String clientId) {
        return GetUserGeolocationRequest.builder().withUserId(userId).withClientId(clientId).build();
    }

    public Geolocation getUserGeolocation(GetUserGeolocationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Geolocation> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Geolocation>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Geolocation> getUserGeolocation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Geolocation>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GeolocationSettings patchGeolocationsSettings(GeolocationSettings body) throws IOException, ApiException {
        return this.patchGeolocationsSettings(this.createPatchGeolocationsSettingsRequest(body));
    }

    public ApiResponse<GeolocationSettings> patchGeolocationsSettingsWithHttpInfo(GeolocationSettings body) throws IOException {
        return this.patchGeolocationsSettings(this.createPatchGeolocationsSettingsRequest(body).withHttpInfo());
    }

    private PatchGeolocationsSettingsRequest createPatchGeolocationsSettingsRequest(GeolocationSettings body) {
        return PatchGeolocationsSettingsRequest.builder().withBody(body).build();
    }

    public GeolocationSettings patchGeolocationsSettings(PatchGeolocationsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GeolocationSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GeolocationSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GeolocationSettings> patchGeolocationsSettings(ApiRequest<GeolocationSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GeolocationSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Geolocation patchUserGeolocation(String userId, String clientId, Geolocation body) throws IOException, ApiException {
        return this.patchUserGeolocation(this.createPatchUserGeolocationRequest(userId, clientId, body));
    }

    public ApiResponse<Geolocation> patchUserGeolocationWithHttpInfo(String userId, String clientId, Geolocation body) throws IOException {
        return this.patchUserGeolocation(this.createPatchUserGeolocationRequest(userId, clientId, body).withHttpInfo());
    }

    private PatchUserGeolocationRequest createPatchUserGeolocationRequest(String userId, String clientId, Geolocation body) {
        return PatchUserGeolocationRequest.builder().withUserId(userId).withClientId(clientId).withBody(body).build();
    }

    public Geolocation patchUserGeolocation(PatchUserGeolocationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Geolocation> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Geolocation>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Geolocation> patchUserGeolocation(ApiRequest<Geolocation> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Geolocation>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

