/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.TrunkConnectedStatus;
import com.mypurecloud.sdk.v2.model.TrunkMetricsNetworkTypeIp;
import com.mypurecloud.sdk.v2.model.TrunkMetricsOptions;
import com.mypurecloud.sdk.v2.model.TrunkMetricsRegisters;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Trunk
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private TrunkTypeEnum trunkType = null;
    private DomainEntityRef edge = null;
    private DomainEntityRef trunkBase = null;
    private DomainEntityRef trunkMetabase = null;
    private DomainEntityRef edgeGroup = null;
    private Boolean inService = null;
    private Boolean enabled = null;
    private DomainEntityRef logicalInterface = null;
    private TrunkConnectedStatus connectedStatus = null;
    private List<TrunkMetricsOptions> optionsStatus = new ArrayList<TrunkMetricsOptions>();
    private List<TrunkMetricsRegisters> registersStatus = new ArrayList<TrunkMetricsRegisters>();
    private TrunkMetricsNetworkTypeIp ipStatus = null;
    private OptionsEnabledStatusEnum optionsEnabledStatus = null;
    private RegistersEnabledStatusEnum registersEnabledStatus = null;
    private Integer family = null;
    private List<String> proxyAddressList = new ArrayList<String>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Trunk name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the entity.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Trunk description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource's description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Trunk version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version of the resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Trunk dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Trunk dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public Trunk modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the resource.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Trunk createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the resource.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="Indicates if the resource is active, inactive, or deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public Trunk modifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that last modified the resource.")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    public void setModifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
    }

    public Trunk createdByApp(String createdByApp) {
        this.createdByApp = createdByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that created the resource.")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public void setCreatedByApp(String createdByApp) {
        this.createdByApp = createdByApp;
    }

    public Trunk trunkType(TrunkTypeEnum trunkType) {
        this.trunkType = trunkType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of this trunk.")
    @JsonProperty(value="trunkType")
    public TrunkTypeEnum getTrunkType() {
        return this.trunkType;
    }

    public void setTrunkType(TrunkTypeEnum trunkType) {
        this.trunkType = trunkType;
    }

    public Trunk edge(DomainEntityRef edge) {
        this.edge = edge;
        return this;
    }

    @ApiModelProperty(example="null", value="The Edge using this trunk.")
    @JsonProperty(value="edge")
    public DomainEntityRef getEdge() {
        return this.edge;
    }

    public void setEdge(DomainEntityRef edge) {
        this.edge = edge;
    }

    public Trunk trunkBase(DomainEntityRef trunkBase) {
        this.trunkBase = trunkBase;
        return this;
    }

    @ApiModelProperty(example="null", value="The trunk base configuration used on this trunk.")
    @JsonProperty(value="trunkBase")
    public DomainEntityRef getTrunkBase() {
        return this.trunkBase;
    }

    public void setTrunkBase(DomainEntityRef trunkBase) {
        this.trunkBase = trunkBase;
    }

    public Trunk trunkMetabase(DomainEntityRef trunkMetabase) {
        this.trunkMetabase = trunkMetabase;
        return this;
    }

    @ApiModelProperty(example="null", value="The metabase used to create this trunk.")
    @JsonProperty(value="trunkMetabase")
    public DomainEntityRef getTrunkMetabase() {
        return this.trunkMetabase;
    }

    public void setTrunkMetabase(DomainEntityRef trunkMetabase) {
        this.trunkMetabase = trunkMetabase;
    }

    public Trunk edgeGroup(DomainEntityRef edgeGroup) {
        this.edgeGroup = edgeGroup;
        return this;
    }

    @ApiModelProperty(example="null", value="The edge group associated with this trunk.")
    @JsonProperty(value="edgeGroup")
    public DomainEntityRef getEdgeGroup() {
        return this.edgeGroup;
    }

    public void setEdgeGroup(DomainEntityRef edgeGroup) {
        this.edgeGroup = edgeGroup;
    }

    @ApiModelProperty(example="null", value="True if this trunk is in-service.  This comes from the trunk_enabled property of the referenced trunk base.")
    @JsonProperty(value="inService")
    public Boolean getInService() {
        return this.inService;
    }

    public Trunk enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the Edge used by this trunk is in-service")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Trunk logicalInterface(DomainEntityRef logicalInterface) {
        this.logicalInterface = logicalInterface;
        return this;
    }

    @ApiModelProperty(example="null", value="The Logical Interface on the Edge to which the trunk is assigned.")
    @JsonProperty(value="logicalInterface")
    public DomainEntityRef getLogicalInterface() {
        return this.logicalInterface;
    }

    public void setLogicalInterface(DomainEntityRef logicalInterface) {
        this.logicalInterface = logicalInterface;
    }

    public Trunk connectedStatus(TrunkConnectedStatus connectedStatus) {
        this.connectedStatus = connectedStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The connected status of the trunk")
    @JsonProperty(value="connectedStatus")
    public TrunkConnectedStatus getConnectedStatus() {
        return this.connectedStatus;
    }

    public void setConnectedStatus(TrunkConnectedStatus connectedStatus) {
        this.connectedStatus = connectedStatus;
    }

    public Trunk optionsStatus(List<TrunkMetricsOptions> optionsStatus) {
        this.optionsStatus = optionsStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The trunk optionsStatus")
    @JsonProperty(value="optionsStatus")
    public List<TrunkMetricsOptions> getOptionsStatus() {
        return this.optionsStatus;
    }

    public void setOptionsStatus(List<TrunkMetricsOptions> optionsStatus) {
        this.optionsStatus = optionsStatus;
    }

    public Trunk registersStatus(List<TrunkMetricsRegisters> registersStatus) {
        this.registersStatus = registersStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The trunk registersStatus")
    @JsonProperty(value="registersStatus")
    public List<TrunkMetricsRegisters> getRegistersStatus() {
        return this.registersStatus;
    }

    public void setRegistersStatus(List<TrunkMetricsRegisters> registersStatus) {
        this.registersStatus = registersStatus;
    }

    public Trunk ipStatus(TrunkMetricsNetworkTypeIp ipStatus) {
        this.ipStatus = ipStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The trunk ipStatus")
    @JsonProperty(value="ipStatus")
    public TrunkMetricsNetworkTypeIp getIpStatus() {
        return this.ipStatus;
    }

    public void setIpStatus(TrunkMetricsNetworkTypeIp ipStatus) {
        this.ipStatus = ipStatus;
    }

    @ApiModelProperty(example="null", value="Returns Enabled when the trunk base supports the availability interval and it has a value greater than 0.")
    @JsonProperty(value="optionsEnabledStatus")
    public OptionsEnabledStatusEnum getOptionsEnabledStatus() {
        return this.optionsEnabledStatus;
    }

    @ApiModelProperty(example="null", value="Returns Enabled when the trunk base supports the registration interval and it has a value greater than 0.")
    @JsonProperty(value="registersEnabledStatus")
    public RegistersEnabledStatusEnum getRegistersEnabledStatus() {
        return this.registersEnabledStatus;
    }

    @ApiModelProperty(example="null", value="The IP Network Family of the trunk")
    @JsonProperty(value="family")
    public Integer getFamily() {
        return this.family;
    }

    public Trunk proxyAddressList(List<String> proxyAddressList) {
        this.proxyAddressList = proxyAddressList;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of proxy addresses (ports if provided) for the trunk")
    @JsonProperty(value="proxyAddressList")
    public List<String> getProxyAddressList() {
        return this.proxyAddressList;
    }

    public void setProxyAddressList(List<String> proxyAddressList) {
        this.proxyAddressList = proxyAddressList;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trunk trunk = (Trunk)o;
        return Objects.equals(this.id, trunk.id) && Objects.equals(this.name, trunk.name) && Objects.equals(this.description, trunk.description) && Objects.equals(this.version, trunk.version) && Objects.equals(this.dateCreated, trunk.dateCreated) && Objects.equals(this.dateModified, trunk.dateModified) && Objects.equals(this.modifiedBy, trunk.modifiedBy) && Objects.equals(this.createdBy, trunk.createdBy) && Objects.equals((Object)this.state, (Object)trunk.state) && Objects.equals(this.modifiedByApp, trunk.modifiedByApp) && Objects.equals(this.createdByApp, trunk.createdByApp) && Objects.equals((Object)this.trunkType, (Object)trunk.trunkType) && Objects.equals(this.edge, trunk.edge) && Objects.equals(this.trunkBase, trunk.trunkBase) && Objects.equals(this.trunkMetabase, trunk.trunkMetabase) && Objects.equals(this.edgeGroup, trunk.edgeGroup) && Objects.equals(this.inService, trunk.inService) && Objects.equals(this.enabled, trunk.enabled) && Objects.equals(this.logicalInterface, trunk.logicalInterface) && Objects.equals(this.connectedStatus, trunk.connectedStatus) && Objects.equals(this.optionsStatus, trunk.optionsStatus) && Objects.equals(this.registersStatus, trunk.registersStatus) && Objects.equals(this.ipStatus, trunk.ipStatus) && Objects.equals((Object)this.optionsEnabledStatus, (Object)trunk.optionsEnabledStatus) && Objects.equals((Object)this.registersEnabledStatus, (Object)trunk.registersEnabledStatus) && Objects.equals(this.family, trunk.family) && Objects.equals(this.proxyAddressList, trunk.proxyAddressList) && Objects.equals(this.selfUri, trunk.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.trunkType, this.edge, this.trunkBase, this.trunkMetabase, this.edgeGroup, this.inService, this.enabled, this.logicalInterface, this.connectedStatus, this.optionsStatus, this.registersStatus, this.ipStatus, this.optionsEnabledStatus, this.registersEnabledStatus, this.family, this.proxyAddressList, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trunk {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    trunkType: ").append(this.toIndentedString((Object)this.trunkType)).append("\n");
        sb.append("    edge: ").append(this.toIndentedString(this.edge)).append("\n");
        sb.append("    trunkBase: ").append(this.toIndentedString(this.trunkBase)).append("\n");
        sb.append("    trunkMetabase: ").append(this.toIndentedString(this.trunkMetabase)).append("\n");
        sb.append("    edgeGroup: ").append(this.toIndentedString(this.edgeGroup)).append("\n");
        sb.append("    inService: ").append(this.toIndentedString(this.inService)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    logicalInterface: ").append(this.toIndentedString(this.logicalInterface)).append("\n");
        sb.append("    connectedStatus: ").append(this.toIndentedString(this.connectedStatus)).append("\n");
        sb.append("    optionsStatus: ").append(this.toIndentedString(this.optionsStatus)).append("\n");
        sb.append("    registersStatus: ").append(this.toIndentedString(this.registersStatus)).append("\n");
        sb.append("    ipStatus: ").append(this.toIndentedString(this.ipStatus)).append("\n");
        sb.append("    optionsEnabledStatus: ").append(this.toIndentedString((Object)this.optionsEnabledStatus)).append("\n");
        sb.append("    registersEnabledStatus: ").append(this.toIndentedString((Object)this.registersEnabledStatus)).append("\n");
        sb.append("    family: ").append(this.toIndentedString(this.family)).append("\n");
        sb.append("    proxyAddressList: ").append(this.toIndentedString(this.proxyAddressList)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RegistersEnabledStatusEnumDeserializer.class)
    public static enum RegistersEnabledStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENABLED("ENABLED"),
        DISABLED("DISABLED"),
        NOT_SUPPORTED("NOT_SUPPORTED");

        private String value;

        private RegistersEnabledStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RegistersEnabledStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RegistersEnabledStatusEnum value : RegistersEnabledStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RegistersEnabledStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RegistersEnabledStatusEnumDeserializer
    extends StdDeserializer<RegistersEnabledStatusEnum> {
        public RegistersEnabledStatusEnumDeserializer() {
            super(RegistersEnabledStatusEnumDeserializer.class);
        }

        public RegistersEnabledStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RegistersEnabledStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=OptionsEnabledStatusEnumDeserializer.class)
    public static enum OptionsEnabledStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENABLED("ENABLED"),
        DISABLED("DISABLED"),
        NOT_SUPPORTED("NOT_SUPPORTED");

        private String value;

        private OptionsEnabledStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OptionsEnabledStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OptionsEnabledStatusEnum value : OptionsEnabledStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OptionsEnabledStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OptionsEnabledStatusEnumDeserializer
    extends StdDeserializer<OptionsEnabledStatusEnum> {
        public OptionsEnabledStatusEnumDeserializer() {
            super(OptionsEnabledStatusEnumDeserializer.class);
        }

        public OptionsEnabledStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OptionsEnabledStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TrunkTypeEnumDeserializer.class)
    public static enum TrunkTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EXTERNAL("EXTERNAL"),
        PHONE("PHONE"),
        EDGE("EDGE");

        private String value;

        private TrunkTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TrunkTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TrunkTypeEnum value : TrunkTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TrunkTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TrunkTypeEnumDeserializer
    extends StdDeserializer<TrunkTypeEnum> {
        public TrunkTypeEnumDeserializer() {
            super(TrunkTypeEnumDeserializer.class);
        }

        public TrunkTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TrunkTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

