/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CredentialInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Effective Configuration for an ClientApp. This is comprised of the integration specific configuration along with overrides specified in the integration type.")
public class EffectiveConfiguration
implements Serializable {
    private Map<String, Object> properties = null;
    private Map<String, Object> advanced = null;
    private String name = null;
    private String notes = null;
    private Map<String, CredentialInfo> credentials = null;

    public EffectiveConfiguration properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Key-value configuration settings described by the schema in the propertiesSchemaUri field.")
    @JsonProperty(value="properties")
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public EffectiveConfiguration advanced(Map<String, Object> advanced) {
        this.advanced = advanced;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Advanced configuration described by the schema in the advancedSchemaUri field.")
    @JsonProperty(value="advanced")
    public Map<String, Object> getAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(Map<String, Object> advanced) {
        this.advanced = advanced;
    }

    public EffectiveConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the integration, used to distinguish this integration from others of the same type.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EffectiveConfiguration notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Notes about the integration.")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public EffectiveConfiguration credentials(Map<String, CredentialInfo> credentials) {
        this.credentials = credentials;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Credentials required by the integration. The required keys are indicated in the credentials property of the Integration Type")
    @JsonProperty(value="credentials")
    public Map<String, CredentialInfo> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, CredentialInfo> credentials) {
        this.credentials = credentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectiveConfiguration effectiveConfiguration = (EffectiveConfiguration)o;
        return Objects.equals(this.properties, effectiveConfiguration.properties) && Objects.equals(this.advanced, effectiveConfiguration.advanced) && Objects.equals(this.name, effectiveConfiguration.name) && Objects.equals(this.notes, effectiveConfiguration.notes) && Objects.equals(this.credentials, effectiveConfiguration.credentials);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.advanced, this.name, this.notes, this.credentials);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EffectiveConfiguration {\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    advanced: ").append(this.toIndentedString(this.advanced)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

