/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetSearchRequest;
import com.mypurecloud.sdk.v2.api.request.GetSearchSuggestRequest;
import com.mypurecloud.sdk.v2.api.request.PostSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PostSearchSuggestRequest;
import com.mypurecloud.sdk.v2.model.JsonNodeSearchResponse;
import com.mypurecloud.sdk.v2.model.SearchRequest;
import com.mypurecloud.sdk.v2.model.SuggestSearchRequest;
import java.util.concurrent.Future;

public class SuggestApiAsync {
    private final ApiClient pcapiClient;

    public SuggestApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public SuggestApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<JsonNodeSearchResponse> getSearchAsync(GetSearchRequest request, final AsyncApiCallback<JsonNodeSearchResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        SuggestApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<JsonNodeSearchResponse>> getSearchAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<JsonNodeSearchResponse> getSearchSuggestAsync(GetSearchSuggestRequest request, final AsyncApiCallback<JsonNodeSearchResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        SuggestApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<JsonNodeSearchResponse>> getSearchSuggestAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<JsonNodeSearchResponse> postSearchAsync(PostSearchRequest request, final AsyncApiCallback<JsonNodeSearchResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        SuggestApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<JsonNodeSearchResponse>> postSearchAsync(ApiRequest<SearchRequest> request, final AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<JsonNodeSearchResponse> postSearchSuggestAsync(PostSearchSuggestRequest request, final AsyncApiCallback<JsonNodeSearchResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        SuggestApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<JsonNodeSearchResponse>> postSearchSuggestAsync(ApiRequest<SuggestSearchRequest> request, final AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<JsonNodeSearchResponse>(){}, new AsyncApiCallback<ApiResponse<JsonNodeSearchResponse>>(){

                @Override
                public void onCompleted(ApiResponse<JsonNodeSearchResponse> response) {
                    SuggestApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        SuggestApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        SuggestApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

