/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.KnowledgeBase;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeTraining
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateTriggered = null;
    private Date dateCompleted = null;
    private StatusEnum status = null;
    private String languageCode = null;
    private KnowledgeBase knowledgeBase = null;
    private String errorMessage = null;
    private KnowledgeDocumentsStateEnum knowledgeDocumentsState = null;
    private Date datePromoted = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeTraining name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Trigger date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateTriggered")
    public Date getDateTriggered() {
        return this.dateTriggered;
    }

    @ApiModelProperty(example="null", value="Training completed date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    @ApiModelProperty(example="null", value="Training status")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Actual language of the Training")
    @JsonProperty(value="languageCode")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public KnowledgeTraining knowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge base which Training does belong to")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    @ApiModelProperty(example="null", value="Any error message during the Training or Promote action.")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @ApiModelProperty(example="null", value="State of the Trained Documents, which can be one of these Draft, Active, Discarded, Archived.")
    @JsonProperty(value="knowledgeDocumentsState")
    public KnowledgeDocumentsStateEnum getKnowledgeDocumentsState() {
        return this.knowledgeDocumentsState;
    }

    @ApiModelProperty(example="null", value="Trained Documents Promoted date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datePromoted")
    public Date getDatePromoted() {
        return this.datePromoted;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeTraining knowledgeTraining = (KnowledgeTraining)o;
        return Objects.equals(this.id, knowledgeTraining.id) && Objects.equals(this.name, knowledgeTraining.name) && Objects.equals(this.dateTriggered, knowledgeTraining.dateTriggered) && Objects.equals(this.dateCompleted, knowledgeTraining.dateCompleted) && Objects.equals((Object)this.status, (Object)knowledgeTraining.status) && Objects.equals(this.languageCode, knowledgeTraining.languageCode) && Objects.equals(this.knowledgeBase, knowledgeTraining.knowledgeBase) && Objects.equals(this.errorMessage, knowledgeTraining.errorMessage) && Objects.equals((Object)this.knowledgeDocumentsState, (Object)knowledgeTraining.knowledgeDocumentsState) && Objects.equals(this.datePromoted, knowledgeTraining.datePromoted) && Objects.equals(this.selfUri, knowledgeTraining.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateTriggered, this.dateCompleted, this.status, this.languageCode, this.knowledgeBase, this.errorMessage, this.knowledgeDocumentsState, this.datePromoted, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeTraining {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateTriggered: ").append(this.toIndentedString(this.dateTriggered)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    knowledgeDocumentsState: ").append(this.toIndentedString((Object)this.knowledgeDocumentsState)).append("\n");
        sb.append("    datePromoted: ").append(this.toIndentedString(this.datePromoted)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KnowledgeDocumentsStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        ACTIVE("Active"),
        DISCARDED("Discarded"),
        ARCHIVED("Archived");

        private String value;

        private KnowledgeDocumentsStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KnowledgeDocumentsStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KnowledgeDocumentsStateEnum value : KnowledgeDocumentsStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KnowledgeDocumentsStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("Queued"),
        INPROGRESS("InProgress"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

