/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetQualityFormVersionsRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String formId;
    private Integer pageSize;
    private Integer pageNumber;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public GetQualityFormVersionsRequest withFormId(String formId) {
        this.setFormId(formId);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetQualityFormVersionsRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetQualityFormVersionsRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetQualityFormVersionsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.formId == null) {
            throw new ApiException(400, "Missing the required parameter 'formId' when building request for GetQualityFormVersionsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/quality/forms/{formId}/versions").withPathParameter("formId", this.formId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String formId) {
        return new Builder().withRequiredParams(formId);
    }

    public static class Builder {
        private final GetQualityFormVersionsRequest request = new GetQualityFormVersionsRequest();

        private Builder() {
        }

        public Builder withFormId(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withRequiredParams(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public GetQualityFormVersionsRequest build() {
            return this.request;
        }
    }
}

