/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteArchitectPromptRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteArchitectPromptResourceRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteArchitectPromptsRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteArchitectSystempromptResourceRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectPromptRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectPromptResourceRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectPromptResourcesRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectPromptsRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectSystempromptRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectSystempromptResourceRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectSystempromptResourcesRequest;
import com.mypurecloud.sdk.v2.api.request.GetArchitectSystempromptsRequest;
import com.mypurecloud.sdk.v2.api.request.GetFlowsRequest;
import com.mypurecloud.sdk.v2.api.request.PostArchitectPromptResourcesRequest;
import com.mypurecloud.sdk.v2.api.request.PostArchitectPromptsRequest;
import com.mypurecloud.sdk.v2.api.request.PostArchitectSystempromptResourcesRequest;
import com.mypurecloud.sdk.v2.api.request.PutArchitectPromptRequest;
import com.mypurecloud.sdk.v2.api.request.PutArchitectPromptResourceRequest;
import com.mypurecloud.sdk.v2.api.request.PutArchitectSystempromptResourceRequest;
import com.mypurecloud.sdk.v2.model.FlowEntityListing;
import com.mypurecloud.sdk.v2.model.Operation;
import com.mypurecloud.sdk.v2.model.Prompt;
import com.mypurecloud.sdk.v2.model.PromptAsset;
import com.mypurecloud.sdk.v2.model.PromptAssetCreate;
import com.mypurecloud.sdk.v2.model.PromptAssetEntityListing;
import com.mypurecloud.sdk.v2.model.PromptEntityListing;
import com.mypurecloud.sdk.v2.model.SystemPrompt;
import com.mypurecloud.sdk.v2.model.SystemPromptAsset;
import com.mypurecloud.sdk.v2.model.SystemPromptAssetEntityListing;
import com.mypurecloud.sdk.v2.model.SystemPromptEntityListing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArchitectApi {
    private final ApiClient pcapiClient;

    public ArchitectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ArchitectApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteArchitectPrompt(String promptId, Boolean allResources) throws ApiException {
        this.deleteArchitectPromptWithHttpInfo(promptId, allResources);
    }

    public ApiResponse<Void> deleteArchitectPromptWithHttpInfo(String promptId, Boolean allResources) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling deleteArchitectPrompt");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "allResources", allResources));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteArchitectPrompt(DeleteArchitectPromptRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteArchitectPrompt(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public void deleteArchitectPromptResource(String promptId, String languageCode) throws ApiException {
        this.deleteArchitectPromptResourceWithHttpInfo(promptId, languageCode);
    }

    public ApiResponse<Void> deleteArchitectPromptResourceWithHttpInfo(String promptId, String languageCode) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling deleteArchitectPromptResource");
        }
        if (languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when calling deleteArchitectPromptResource");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString())).replaceAll("\\{languageCode\\}", this.pcapiClient.escapeString(languageCode.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteArchitectPromptResource(DeleteArchitectPromptResourceRequest request) throws ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteArchitectPromptResource(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public Operation deleteArchitectPrompts(List<String> id) throws ApiException {
        return this.deleteArchitectPromptsWithHttpInfo(id).getBody();
    }

    public ApiResponse<Operation> deleteArchitectPromptsWithHttpInfo(List<String> id) throws ApiException {
        Object pclocalVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteArchitectPrompts");
        }
        String pclocalVarPath = "/api/v2/architect/prompts".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "id", id));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Operation>(){});
    }

    public Operation deleteArchitectPrompts(DeleteArchitectPromptsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Operation>(){});
    }

    public ApiResponse<Operation> deleteArchitectPrompts(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Operation>(){});
    }

    public String deleteArchitectSystempromptResource(String promptId, String languageCode) throws ApiException {
        return this.deleteArchitectSystempromptResourceWithHttpInfo(promptId, languageCode).getBody();
    }

    public ApiResponse<String> deleteArchitectSystempromptResourceWithHttpInfo(String promptId, String languageCode) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling deleteArchitectSystempromptResource");
        }
        if (languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when calling deleteArchitectSystempromptResource");
        }
        String pclocalVarPath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString())).replaceAll("\\{languageCode\\}", this.pcapiClient.escapeString(languageCode.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<String>(){});
    }

    public String deleteArchitectSystempromptResource(DeleteArchitectSystempromptResourceRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<String>(){});
    }

    public ApiResponse<String> deleteArchitectSystempromptResource(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<String>(){});
    }

    public Prompt getArchitectPrompt(String promptId) throws ApiException {
        return this.getArchitectPromptWithHttpInfo(promptId).getBody();
    }

    public ApiResponse<Prompt> getArchitectPromptWithHttpInfo(String promptId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling getArchitectPrompt");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Prompt>(){});
    }

    public Prompt getArchitectPrompt(GetArchitectPromptRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Prompt>(){});
    }

    public ApiResponse<Prompt> getArchitectPrompt(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Prompt>(){});
    }

    public PromptAsset getArchitectPromptResource(String promptId, String languageCode) throws ApiException {
        return this.getArchitectPromptResourceWithHttpInfo(promptId, languageCode).getBody();
    }

    public ApiResponse<PromptAsset> getArchitectPromptResourceWithHttpInfo(String promptId, String languageCode) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling getArchitectPromptResource");
        }
        if (languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when calling getArchitectPromptResource");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString())).replaceAll("\\{languageCode\\}", this.pcapiClient.escapeString(languageCode.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<PromptAsset>(){});
    }

    public PromptAsset getArchitectPromptResource(GetArchitectPromptResourceRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<PromptAsset>(){});
    }

    public ApiResponse<PromptAsset> getArchitectPromptResource(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<PromptAsset>(){});
    }

    public PromptAssetEntityListing getArchitectPromptResources(String promptId, Integer pageNumber, Integer pageSize) throws ApiException {
        return this.getArchitectPromptResourcesWithHttpInfo(promptId, pageNumber, pageSize).getBody();
    }

    public ApiResponse<PromptAssetEntityListing> getArchitectPromptResourcesWithHttpInfo(String promptId, Integer pageNumber, Integer pageSize) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling getArchitectPromptResources");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}/resources".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<PromptAssetEntityListing>(){});
    }

    public PromptAssetEntityListing getArchitectPromptResources(GetArchitectPromptResourcesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<PromptAssetEntityListing>(){});
    }

    public ApiResponse<PromptAssetEntityListing> getArchitectPromptResources(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<PromptAssetEntityListing>(){});
    }

    public PromptEntityListing getArchitectPrompts(Integer pageNumber, Integer pageSize, String name, String description, String nameOrDescription) throws ApiException {
        return this.getArchitectPromptsWithHttpInfo(pageNumber, pageSize, name, description, nameOrDescription).getBody();
    }

    public ApiResponse<PromptEntityListing> getArchitectPromptsWithHttpInfo(Integer pageNumber, Integer pageSize, String name, String description, String nameOrDescription) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/architect/prompts".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "description", description));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nameOrDescription", nameOrDescription));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<PromptEntityListing>(){});
    }

    public PromptEntityListing getArchitectPrompts(GetArchitectPromptsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<PromptEntityListing>(){});
    }

    public ApiResponse<PromptEntityListing> getArchitectPrompts(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<PromptEntityListing>(){});
    }

    public SystemPrompt getArchitectSystemprompt(String promptId) throws ApiException {
        return this.getArchitectSystempromptWithHttpInfo(promptId).getBody();
    }

    public ApiResponse<SystemPrompt> getArchitectSystempromptWithHttpInfo(String promptId) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling getArchitectSystemprompt");
        }
        String pclocalVarPath = "/api/v2/architect/systemprompts/{promptId}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<SystemPrompt>(){});
    }

    public SystemPrompt getArchitectSystemprompt(GetArchitectSystempromptRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<SystemPrompt>(){});
    }

    public ApiResponse<SystemPrompt> getArchitectSystemprompt(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<SystemPrompt>(){});
    }

    public SystemPromptAsset getArchitectSystempromptResource(String promptId, String languageCode) throws ApiException {
        return this.getArchitectSystempromptResourceWithHttpInfo(promptId, languageCode).getBody();
    }

    public ApiResponse<SystemPromptAsset> getArchitectSystempromptResourceWithHttpInfo(String promptId, String languageCode) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling getArchitectSystempromptResource");
        }
        if (languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when calling getArchitectSystempromptResource");
        }
        String pclocalVarPath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString())).replaceAll("\\{languageCode\\}", this.pcapiClient.escapeString(languageCode.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<SystemPromptAsset>(){});
    }

    public SystemPromptAsset getArchitectSystempromptResource(GetArchitectSystempromptResourceRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<SystemPromptAsset>(){});
    }

    public ApiResponse<SystemPromptAsset> getArchitectSystempromptResource(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<SystemPromptAsset>(){});
    }

    public SystemPromptAssetEntityListing getArchitectSystempromptResources(String promptId, Integer pageNumber, Integer pageSize, String sortBy, String sortOrder) throws ApiException {
        return this.getArchitectSystempromptResourcesWithHttpInfo(promptId, pageNumber, pageSize, sortBy, sortOrder).getBody();
    }

    public ApiResponse<SystemPromptAssetEntityListing> getArchitectSystempromptResourcesWithHttpInfo(String promptId, Integer pageNumber, Integer pageSize, String sortBy, String sortOrder) throws ApiException {
        Object pclocalVarPostBody = null;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling getArchitectSystempromptResources");
        }
        String pclocalVarPath = "/api/v2/architect/systemprompts/{promptId}/resources".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<SystemPromptAssetEntityListing>(){});
    }

    public SystemPromptAssetEntityListing getArchitectSystempromptResources(GetArchitectSystempromptResourcesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<SystemPromptAssetEntityListing>(){});
    }

    public ApiResponse<SystemPromptAssetEntityListing> getArchitectSystempromptResources(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<SystemPromptAssetEntityListing>(){});
    }

    public SystemPromptEntityListing getArchitectSystemprompts(Integer pageNumber, Integer pageSize, String sortBy, String sortOrder, String name, String description, String nameOrDescription) throws ApiException {
        return this.getArchitectSystempromptsWithHttpInfo(pageNumber, pageSize, sortBy, sortOrder, name, description, nameOrDescription).getBody();
    }

    public ApiResponse<SystemPromptEntityListing> getArchitectSystempromptsWithHttpInfo(Integer pageNumber, Integer pageSize, String sortBy, String sortOrder, String name, String description, String nameOrDescription) throws ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/architect/systemprompts".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "description", description));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nameOrDescription", nameOrDescription));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<SystemPromptEntityListing>(){});
    }

    public SystemPromptEntityListing getArchitectSystemprompts(GetArchitectSystempromptsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<SystemPromptEntityListing>(){});
    }

    public ApiResponse<SystemPromptEntityListing> getArchitectSystemprompts(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<SystemPromptEntityListing>(){});
    }

    public FlowEntityListing getFlows(String type, Integer pageNumber, Integer pageSize, String sortBy, String sortOrder, List<String> id, String name, String description, String nameOrDescription, String publishVersionId, String editableBy, String lockedBy, String secure, Boolean deleted, Boolean includeSchemas) throws ApiException {
        return this.getFlowsWithHttpInfo(type, pageNumber, pageSize, sortBy, sortOrder, id, name, description, nameOrDescription, publishVersionId, editableBy, lockedBy, secure, deleted, includeSchemas).getBody();
    }

    public ApiResponse<FlowEntityListing> getFlowsWithHttpInfo(String type, Integer pageNumber, Integer pageSize, String sortBy, String sortOrder, List<String> id, String name, String description, String nameOrDescription, String publishVersionId, String editableBy, String lockedBy, String secure, Boolean deleted, Boolean includeSchemas) throws ApiException {
        Object pclocalVarPostBody = null;
        if (type == null) {
            throw new ApiException(400, "Missing the required parameter 'type' when calling getFlows");
        }
        String pclocalVarPath = "/api/v2/flows".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "type", type));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortOrder", sortOrder));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "id", id));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "description", description));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nameOrDescription", nameOrDescription));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "publishVersionId", publishVersionId));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "editableBy", editableBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "lockedBy", lockedBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "secure", secure));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "deleted", deleted));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "includeSchemas", includeSchemas));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<FlowEntityListing>(){});
    }

    public FlowEntityListing getFlows(GetFlowsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<FlowEntityListing>(){});
    }

    public ApiResponse<FlowEntityListing> getFlows(ApiRequest<Void> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<FlowEntityListing>(){});
    }

    public PromptAsset postArchitectPromptResources(String promptId, PromptAssetCreate body) throws ApiException {
        return this.postArchitectPromptResourcesWithHttpInfo(promptId, body).getBody();
    }

    public ApiResponse<PromptAsset> postArchitectPromptResourcesWithHttpInfo(String promptId, PromptAssetCreate body) throws ApiException {
        PromptAssetCreate pclocalVarPostBody = body;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling postArchitectPromptResources");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}/resources".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<PromptAsset>(){});
    }

    public PromptAsset postArchitectPromptResources(PostArchitectPromptResourcesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<PromptAsset>(){});
    }

    public ApiResponse<PromptAsset> postArchitectPromptResources(ApiRequest<PromptAssetCreate> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<PromptAsset>(){});
    }

    public Prompt postArchitectPrompts(Prompt body) throws ApiException {
        return this.postArchitectPromptsWithHttpInfo(body).getBody();
    }

    public ApiResponse<Prompt> postArchitectPromptsWithHttpInfo(Prompt body) throws ApiException {
        Prompt pclocalVarPostBody = body;
        String pclocalVarPath = "/api/v2/architect/prompts".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Prompt>(){});
    }

    public Prompt postArchitectPrompts(PostArchitectPromptsRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Prompt>(){});
    }

    public ApiResponse<Prompt> postArchitectPrompts(ApiRequest<Prompt> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Prompt>(){});
    }

    public SystemPromptAsset postArchitectSystempromptResources(String promptId, SystemPromptAsset body) throws ApiException {
        return this.postArchitectSystempromptResourcesWithHttpInfo(promptId, body).getBody();
    }

    public ApiResponse<SystemPromptAsset> postArchitectSystempromptResourcesWithHttpInfo(String promptId, SystemPromptAsset body) throws ApiException {
        SystemPromptAsset pclocalVarPostBody = body;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling postArchitectSystempromptResources");
        }
        String pclocalVarPath = "/api/v2/architect/systemprompts/{promptId}/resources".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<SystemPromptAsset>(){});
    }

    public SystemPromptAsset postArchitectSystempromptResources(PostArchitectSystempromptResourcesRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<SystemPromptAsset>(){});
    }

    public ApiResponse<SystemPromptAsset> postArchitectSystempromptResources(ApiRequest<SystemPromptAsset> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<SystemPromptAsset>(){});
    }

    public Prompt putArchitectPrompt(String promptId, Prompt body) throws ApiException {
        return this.putArchitectPromptWithHttpInfo(promptId, body).getBody();
    }

    public ApiResponse<Prompt> putArchitectPromptWithHttpInfo(String promptId, Prompt body) throws ApiException {
        Prompt pclocalVarPostBody = body;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling putArchitectPrompt");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Prompt>(){});
    }

    public Prompt putArchitectPrompt(PutArchitectPromptRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Prompt>(){});
    }

    public ApiResponse<Prompt> putArchitectPrompt(ApiRequest<Prompt> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Prompt>(){});
    }

    public PromptAsset putArchitectPromptResource(String promptId, String languageCode, PromptAsset body) throws ApiException {
        return this.putArchitectPromptResourceWithHttpInfo(promptId, languageCode, body).getBody();
    }

    public ApiResponse<PromptAsset> putArchitectPromptResourceWithHttpInfo(String promptId, String languageCode, PromptAsset body) throws ApiException {
        PromptAsset pclocalVarPostBody = body;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling putArchitectPromptResource");
        }
        if (languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when calling putArchitectPromptResource");
        }
        String pclocalVarPath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString())).replaceAll("\\{languageCode\\}", this.pcapiClient.escapeString(languageCode.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<PromptAsset>(){});
    }

    public PromptAsset putArchitectPromptResource(PutArchitectPromptResourceRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<PromptAsset>(){});
    }

    public ApiResponse<PromptAsset> putArchitectPromptResource(ApiRequest<PromptAsset> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<PromptAsset>(){});
    }

    public SystemPromptAsset putArchitectSystempromptResource(String promptId, String languageCode, SystemPromptAsset body) throws ApiException {
        return this.putArchitectSystempromptResourceWithHttpInfo(promptId, languageCode, body).getBody();
    }

    public ApiResponse<SystemPromptAsset> putArchitectSystempromptResourceWithHttpInfo(String promptId, String languageCode, SystemPromptAsset body) throws ApiException {
        SystemPromptAsset pclocalVarPostBody = body;
        if (promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when calling putArchitectSystempromptResource");
        }
        if (languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when calling putArchitectSystempromptResource");
        }
        String pclocalVarPath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}".replaceAll("\\{format\\}", "json").replaceAll("\\{promptId\\}", this.pcapiClient.escapeString(promptId.toString())).replaceAll("\\{languageCode\\}", this.pcapiClient.escapeString(languageCode.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<SystemPromptAsset>(){});
    }

    public SystemPromptAsset putArchitectSystempromptResource(PutArchitectSystempromptResourceRequest request) throws ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<SystemPromptAsset>(){});
    }

    public ApiResponse<SystemPromptAsset> putArchitectSystempromptResource(ApiRequest<SystemPromptAsset> request) throws ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<SystemPromptAsset>(){});
    }
}

