/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Note;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutExternalcontactsContactNoteRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String contactId;
    private String noteId;
    private Note body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public PutExternalcontactsContactNoteRequest withContactId(String contactId) {
        this.setContactId(contactId);
        return this;
    }

    public String getNoteId() {
        return this.noteId;
    }

    public void setNoteId(String noteId) {
        this.noteId = noteId;
    }

    public PutExternalcontactsContactNoteRequest withNoteId(String noteId) {
        this.setNoteId(noteId);
        return this;
    }

    public Note getBody() {
        return this.body;
    }

    public void setBody(Note body) {
        this.body = body;
    }

    public PutExternalcontactsContactNoteRequest withBody(Note body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutExternalcontactsContactNoteRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Note> withHttpInfo() throws ApiException {
        if (this.contactId == null) {
            throw new ApiException(400, "Missing the required parameter 'contactId' when building request for PutExternalcontactsContactNoteRequest.");
        }
        if (this.noteId == null) {
            throw new ApiException(400, "Missing the required parameter 'noteId' when building request for PutExternalcontactsContactNoteRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}").withPathParameter("contactId", this.contactId).withPathParameter("noteId", this.noteId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String contactId, String noteId) {
        return new Builder().withRequiredParams(contactId, noteId);
    }

    public static class Builder {
        private final PutExternalcontactsContactNoteRequest request = new PutExternalcontactsContactNoteRequest();

        private Builder() {
        }

        public Builder withContactId(String contactId) {
            this.request.setContactId(contactId);
            return this;
        }

        public Builder withNoteId(String noteId) {
            this.request.setNoteId(noteId);
            return this;
        }

        public Builder withBody(Note body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String contactId, String noteId) {
            this.request.setContactId(contactId);
            this.request.setNoteId(noteId);
            return this;
        }

        public PutExternalcontactsContactNoteRequest build() {
            return this.request;
        }
    }
}

