/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CallCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostConversationsCallRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callId;
    private CallCommand body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public PostConversationsCallRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public CallCommand getBody() {
        return this.body;
    }

    public void setBody(CallCommand body) {
        this.body = body;
    }

    public PostConversationsCallRequest withBody(CallCommand body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsCallRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CallCommand> withHttpInfo() throws ApiException {
        if (this.callId == null) {
            throw new ApiException(400, "Missing the required parameter 'callId' when building request for PostConversationsCallRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostConversationsCallRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/calls/{callId}").withPathParameter("callId", this.callId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId, CallCommand body) {
        return new Builder().withRequiredParams(callId, body);
    }

    public static class Builder {
        private final PostConversationsCallRequest request = new PostConversationsCallRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withBody(CallCommand body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callId, CallCommand body) {
            this.request.setCallId(callId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsCallRequest build() {
            return this.request;
        }
    }
}

