/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteRoutingEmailDomainRouteRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String domainName;
    private String routeId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public DeleteRoutingEmailDomainRouteRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public DeleteRoutingEmailDomainRouteRequest withRouteId(String routeId) {
        this.setRouteId(routeId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteRoutingEmailDomainRouteRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.domainName == null) {
            throw new ApiException(400, "Missing the required parameter 'domainName' when building request for DeleteRoutingEmailDomainRouteRequest.");
        }
        if (this.routeId == null) {
            throw new ApiException(400, "Missing the required parameter 'routeId' when building request for DeleteRoutingEmailDomainRouteRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/routing/email/domains/{domainName}/routes/{routeId}").withPathParameter("domainName", this.domainName).withPathParameter("routeId", this.routeId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainName, String routeId) {
        return new Builder().withRequiredParams(domainName, routeId);
    }

    public static class Builder {
        private final DeleteRoutingEmailDomainRouteRequest request = new DeleteRoutingEmailDomainRouteRequest();

        private Builder() {
        }

        public Builder withDomainName(String domainName) {
            this.request.setDomainName(domainName);
            return this;
        }

        public Builder withRouteId(String routeId) {
            this.request.setRouteId(routeId);
            return this;
        }

        public Builder withRequiredParams(String domainName, String routeId) {
            this.request.setDomainName(domainName);
            this.request.setRouteId(routeId);
            return this;
        }

        public DeleteRoutingEmailDomainRouteRequest build() {
            return this.request;
        }
    }
}

