/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SystemPromptAsset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutArchitectSystempromptResourceRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String promptId;
    private String languageCode;
    private SystemPromptAsset body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getPromptId() {
        return this.promptId;
    }

    public void setPromptId(String promptId) {
        this.promptId = promptId;
    }

    public PutArchitectSystempromptResourceRequest withPromptId(String promptId) {
        this.setPromptId(promptId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PutArchitectSystempromptResourceRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public SystemPromptAsset getBody() {
        return this.body;
    }

    public void setBody(SystemPromptAsset body) {
        this.body = body;
    }

    public PutArchitectSystempromptResourceRequest withBody(SystemPromptAsset body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutArchitectSystempromptResourceRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SystemPromptAsset> withHttpInfo() throws ApiException {
        if (this.promptId == null) {
            throw new ApiException(400, "Missing the required parameter 'promptId' when building request for PutArchitectSystempromptResourceRequest.");
        }
        if (this.languageCode == null) {
            throw new ApiException(400, "Missing the required parameter 'languageCode' when building request for PutArchitectSystempromptResourceRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}").withPathParameter("promptId", this.promptId).withPathParameter("languageCode", this.languageCode).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String promptId, String languageCode) {
        return new Builder().withRequiredParams(promptId, languageCode);
    }

    public static class Builder {
        private final PutArchitectSystempromptResourceRequest request = new PutArchitectSystempromptResourceRequest();

        private Builder() {
        }

        public Builder withPromptId(String promptId) {
            this.request.setPromptId(promptId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withBody(SystemPromptAsset body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String promptId, String languageCode) {
            this.request.setPromptId(promptId);
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public PutArchitectSystempromptResourceRequest build() {
            return this.request;
        }
    }
}

