/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetScriptRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String scriptId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public GetScriptRequest withScriptId(String scriptId) {
        this.setScriptId(scriptId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScriptRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.scriptId == null) {
            throw new ApiException(400, "Missing the required parameter 'scriptId' when building request for GetScriptRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scripts/{scriptId}").withPathParameter("scriptId", this.scriptId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scriptId) {
        return new Builder().withRequiredParams(scriptId);
    }

    public static class Builder {
        private final GetScriptRequest request = new GetScriptRequest();

        private Builder() {
        }

        public Builder withScriptId(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public Builder withRequiredParams(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public GetScriptRequest build() {
            return this.request;
        }
    }
}

