/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.InputStream;
import java.net.URLDecoder;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.filter.StrAttackFilter;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    private static String minioUrl;
    private static String minioName;
    private static String minioPass;
    private static String bucketName;
    private static MinioClient minioClient;

    public static void setMinioUrl(String minioUrl) {
        MinioUtil.minioUrl = minioUrl;
    }

    public static void setMinioName(String minioName) {
        MinioUtil.minioName = minioName;
    }

    public static void setMinioPass(String minioPass) {
        MinioUtil.minioPass = minioPass;
    }

    public static void setBucketName(String bucketName) {
        MinioUtil.bucketName = bucketName;
    }

    public static String getMinioUrl() {
        return minioUrl;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static String upload(MultipartFile file, String bizPath, String customBucket) {
        String file_url = "";
        bizPath = StrAttackFilter.filter(bizPath);
        String newBucket = bucketName;
        if (oConvertUtils.isNotEmpty(customBucket)) {
            newBucket = customBucket;
        }
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            if (minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(newBucket)).build())) {
                log.info("Bucket already exists.");
            } else {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(newBucket)).build());
                log.info("create a new bucket.");
            }
            InputStream stream = file.getInputStream();
            String orgName = file.getOriginalFilename();
            if ("".equals(orgName)) {
                orgName = file.getName();
            }
            orgName = CommonUtils.getFileName(orgName);
            String objectName = bizPath + "/" + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf("."));
            if (objectName.startsWith("/")) {
                objectName = objectName.substring(1);
            }
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().object(objectName)).bucket(newBucket)).contentType("application/octet-stream").stream(stream, (long)stream.available(), -1L).build();
            minioClient.putObject(objectArgs);
            stream.close();
            file_url = minioUrl + newBucket + "/" + objectName;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return file_url;
    }

    public static String upload(MultipartFile file, String bizPath) {
        return MinioUtil.upload(file, bizPath, null);
    }

    public static InputStream getMinioFile(String bucketName, String objectName) {
        GetObjectResponse inputStream = null;
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().object(objectName)).bucket(bucketName)).build();
            inputStream = minioClient.getObject(objectArgs);
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        return inputStream;
    }

    public static void removeObject(String bucketName, String objectName) {
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            RemoveObjectArgs objectArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().object(objectName)).bucket(bucketName)).build();
            minioClient.removeObject(objectArgs);
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + e.getMessage());
        }
    }

    public static String getObjectURL(String bucketName, String objectName, Integer expires) {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        try {
            GetPresignedObjectUrlArgs objectArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().object(objectName)).bucket(bucketName)).expiry(expires.intValue()).build();
            String url = minioClient.getPresignedObjectUrl(objectArgs);
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    private static MinioClient initMinio(String minioUrl, String minioName, String minioPass) {
        if (minioClient == null) {
            try {
                minioClient = MinioClient.builder().endpoint(minioUrl).credentials(minioName, minioPass).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return minioClient;
    }

    public static String upload(InputStream stream, String relativePath) throws Exception {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            log.info("create a new bucket.");
        }
        PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().object(relativePath)).bucket(bucketName)).contentType("application/octet-stream").stream(stream, (long)stream.available(), -1L).build();
        minioClient.putObject(objectArgs);
        stream.close();
        return minioUrl + bucketName + "/" + relativePath;
    }

    static {
        minioClient = null;
    }
}

