/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.packager.Pom;

class ResolvedPom
implements Pom {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final List<ArtifactCoordinates> dependencies;
    private final List<Path> resourcesLocation = new LinkedList<Path>();

    ResolvedPom(MavenProject project) {
        this.groupId = project.getGroupId();
        this.artifactId = project.getArtifactId();
        this.version = project.getVersion();
        this.dependencies = project.getDependencies().parallelStream().map(dependency -> new ArtifactCoordinates(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier(), dependency.getScope())).collect(Collectors.toList());
        project.getResources().forEach(resource -> this.resourcesLocation.add(Paths.get(resource.getDirectory(), new String[0])));
    }

    public void persist(Path pom) {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ArtifactCoordinates> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public List<Path> getResourcesLocation() {
        return Collections.unmodifiableList(this.resourcesLocation);
    }
}

