/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.munit.Coverage;
import org.mule.munit.ResolvedPom;
import org.mule.munit.coverage.CoverageLimitsChecker;
import org.mule.munit.mojo.ApplicationResultPrinterFactory;
import org.mule.munit.mojo.exceptions.MojoExecutionExceptionFactory;
import org.mule.munit.plugin.maven.AbstractMunitMojo;
import org.mule.munit.plugin.maven.project.ApplicationStructureGenerator;
import org.mule.munit.plugin.maven.project.MuleApplicationStructureGenerator;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runtime.RuntimeProducts;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.coverage.model.ApplicationCoverageReport;
import org.mule.munit.util.ApplicationRunConfigurationFactory;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.packager.Pom;
import org.mule.tools.api.packager.builder.MulePackageBuilder;
import org.mule.tools.api.util.MavenComponents;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE)
public class MUnitMojo
extends AbstractMunitMojo {
    protected static final String GROUP_ID_ELEMENT = "groupId";
    protected static final String ARTIFACT_ID_ELEMENT = "artifactId";
    protected static final String MULE_MAVEN_PLUGIN_KEY = "org.mule.tools.maven:mule-maven-plugin";
    protected static final String SHARED_LIBRARIES_KEY = "sharedLibraries";
    @Parameter(property="munit.coverage")
    protected Coverage coverage;
    @Parameter(defaultValue="${munit.randomFailMessages}")
    private boolean randomFailMessages = false;
    @Parameter(defaultValue="${plugin.version}")
    protected String pluginVersion;
    @Parameter(property="munit.coverageReportData", defaultValue="${project.build.directory}/munit-reports/coverage-report.data")
    protected File coverageReportDataFile;
    @Parameter(property="munit.coverageConfigData", defaultValue="${project.build.directory}/munit-reports/coverage-config.data")
    protected File coverageConfigDataFile;
    @Parameter(property="munit.socketPort")
    public String socketPort;
    @Parameter(property="munit.runToken")
    public String runToken;
    protected MojoExecutionExceptionFactory exceptionFactory;
    protected CoverageLimitsChecker coverageLimitsChecker;

    protected void init() throws MojoExecutionException {
        super.init();
        this.checkCoverage();
        this.exceptionFactory = new MojoExecutionExceptionFactory(this.randomFailMessages);
        this.coverageLimitsChecker = new CoverageLimitsChecker(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct(), this.getLog());
    }

    protected void initConfiguration() {
        super.initConfiguration();
    }

    protected void handleRunResult(TargetProduct targetProduct, RunResult runResult) {
        super.handleRunResult(targetProduct, runResult);
        runResult.getApplicationCoverageReport().ifPresent(this.coverageLimitsChecker::setCoverageReport);
        this.saveRunDataToFile(runResult);
    }

    protected void failBuildIfNecessary(Map<TargetProduct, RunResult> runResults) throws MojoExecutionException {
        try {
            super.failBuildIfNecessary(runResults);
        }
        catch (MojoExecutionException cause) {
            throw this.exceptionFactory.buildException("Build Failed", cause);
        }
        if (this.coverage != null && this.coverage.isRunCoverage().booleanValue() && !RuntimeProducts.EE.value().equals(this.muleApplicationModelLoader.getRuntimeProduct())) {
            this.getLog().warn((CharSequence)"Coverage is a EE only feature and you've selected to run over CE");
        }
        if (this.coverageLimitsChecker.failBuild().booleanValue()) {
            throw new MojoExecutionException("Build Failed", (Exception)new MojoFailureException("Coverage limits were not reached"));
        }
    }

    protected Map<TargetProduct, RunConfiguration> getRunConfigurations() throws MojoExecutionException {
        return super.getRunConfigurations();
    }

    protected String getVersion() {
        return this.pluginVersion;
    }

    protected RunConfiguration createRunConfiguration(TargetProduct targetProduct) throws MojoExecutionException {
        return new ApplicationRunConfigurationFactory(this.getLog(), this.munitTest, this.munitTags, this.skipAfterFailure, targetProduct, this.workingDirectoryGenerator, this.munitTestsDirectory, this.coverage, this.debugger, this.pluginVersion, this.project, this.session, this.clearParameters, this.socketPort, this.runToken).create();
    }

    protected ResultPrinterFactory getResultPrinterFactory() {
        return new ApplicationResultPrinterFactory(this.getLog()).withCoverageSummaryReport(this.coverage, this.muleApplicationModelLoader.getRuntimeProduct()).withSurefireReports(this.enableSurefireReports, this.surefireReportsFolder, this.effectiveSystemProperties).withSonarReports(Boolean.valueOf(this.enableSonarReports), this.sonarReportsFolder).withTestOutputReports(Boolean.valueOf(this.redirectTestOutputToFile), this.testOutputDirectory);
    }

    protected ApplicationStructureGenerator getApplicationStructureGenerator() {
        return new MuleApplicationStructureGenerator(this.projectBaseFolder.toPath(), this.outputDirectory.toPath()).withPom((Pom)new ResolvedPom(this.project)).withDependencies(this.createDependencies()).withPackageBuilder(new MulePackageBuilder()).withMavenComponents(this.getMavenComponents()).isHeavyWeight(false);
    }

    protected File getMuleApplicationJsonPath() {
        Path projectBuildDirectoryPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path muleApplicationJsonPath = projectBuildDirectoryPath.resolve(FolderNames.META_INF.value()).resolve(FolderNames.MULE_ARTIFACT.value()).resolve("mule-artifact.json");
        return muleApplicationJsonPath.toFile();
    }

    private void saveRunDataToFile(RunResult runResult) {
        this.saveAsJsonDataToFile(this.coverage == null ? new Coverage() : this.coverage, this.coverageConfigDataFile);
        runResult.getApplicationCoverageReport().ifPresent(this::saveCoverageReportDataToFile);
    }

    private void saveCoverageReportDataToFile(ApplicationCoverageReport applicationCoverageReport) {
        this.saveAsJsonDataToFile(applicationCoverageReport, this.coverageReportDataFile);
    }

    private List<BundleDependency> createDependencies() {
        Set artifacts = this.project.getArtifacts();
        TreeSet direct = new TreeSet();
        Map transitive = artifacts.parallelStream().collect(Collectors.toMap(Function.identity(), unused -> new TreeSet()));
        for (Artifact artifact2 : artifacts) {
            Artifact predecessor = this.findArtifact((Set<Artifact>)artifacts, artifact2.getDependencyTrail());
            ((Set)transitive.getOrDefault(predecessor, direct)).add(artifact2);
        }
        return direct.parallelStream().map(artifact -> this.toDependency((Artifact)artifact, transitive)).collect(Collectors.toList());
    }

    private BundleDescriptor toDescriptor(Artifact artifact) {
        return new BundleDescriptor.Builder().setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setVersion(artifact.getVersion()).setType(artifact.getType()).setClassifier(artifact.getClassifier()).build();
    }

    private Artifact findArtifact(Set<Artifact> artifacts, List<String> trail) {
        return this.findArtifact(artifacts, trail.get(trail.size() - 2));
    }

    private Artifact findArtifact(Set<Artifact> artifacts, String id) {
        return artifacts.parallelStream().filter(artifact -> Objects.equals(artifact.getId(), id)).findAny().orElse(null);
    }

    private BundleScope toScope(Artifact artifact) {
        return Optional.ofNullable(artifact.getScope()).map(scope -> BundleScope.valueOf((String)scope.toUpperCase())).orElse(BundleScope.COMPILE);
    }

    private URI toUri(Artifact artifact) {
        return artifact.getFile().toURI();
    }

    private BundleDependency toDependency(Artifact artifact, Map<Artifact, Set<Artifact>> transitive) {
        BundleDependency.Builder builder = new BundleDependency.Builder();
        builder.setDescriptor(this.toDescriptor(artifact));
        builder.setScope(this.toScope(artifact));
        builder.setBundleUri(this.toUri(artifact));
        for (Artifact transitiveArtifact : transitive.get(artifact)) {
            builder.addTransitiveDependency(this.toDependency(transitiveArtifact, transitive));
        }
        return builder.build();
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((CharSequence)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        return childValue;
    }

    private MavenComponents getMavenComponents() {
        return new MavenComponents().withLog(this.getLog()).withProject(this.project).withOutputDirectory(this.outputDirectory).withSession(this.session).withSharedLibraries(this.getSharedLibraries()).withProjectBuilder(this.projectBuilder).withRepositorySystem(this.mavenRepositorySystem).withLocalRepository(this.localRepository).withRemoteArtifactRepositories(this.remoteArtifactRepositories).withAdditionalPluginDependencies(this.getAdditionalPluginDependencies()).withProjectBaseFolder(this.projectBaseFolder);
    }

    private List<org.mule.tools.api.muleclassloader.model.resolver.Plugin> getAdditionalPluginDependencies() {
        Vector<org.mule.tools.api.muleclassloader.model.resolver.Plugin> plugins = new Vector<org.mule.tools.api.muleclassloader.model.resolver.Plugin>();
        try {
            Xpp3Dom additionalPluginElement;
            Xpp3Dom configuration;
            Plugin plugin = this.project.getPlugin(MULE_MAVEN_PLUGIN_KEY);
            if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null && (additionalPluginElement = configuration.getChild("additionalPluginDependencies")) != null) {
                Xpp3Dom[] libraries = additionalPluginElement.getChildren();
                Arrays.stream(libraries).forEach(library -> {
                    Xpp3Dom additionalPluginDepedencies = configuration.getChild("additionalPluginDependencies");
                    if (additionalPluginDepedencies != null) {
                        Xpp3Dom pluginDependency = additionalPluginDepedencies.getChild("plugin");
                        String pluginGroupId = this.getChildParameterValue(pluginDependency, GROUP_ID_ELEMENT, true);
                        String pluginArtifactId = this.getChildParameterValue(pluginDependency, ARTIFACT_ID_ELEMENT, true);
                        org.mule.tools.api.muleclassloader.model.resolver.Plugin dependency = new org.mule.tools.api.muleclassloader.model.resolver.Plugin();
                        dependency.setArtifactId(pluginArtifactId);
                        dependency.setGroupId(pluginGroupId);
                        ArrayList additionalDependencies = new ArrayList();
                        Arrays.stream(pluginDependency.getChild("additionalDependencies").getChildren()).forEach(lib -> {
                            Dependency additionalDependency = new Dependency();
                            String additionalDependencyGroupId = this.getChildParameterValue((Xpp3Dom)lib, GROUP_ID_ELEMENT, true);
                            String additionalDependencyArtifactId = this.getChildParameterValue((Xpp3Dom)lib, ARTIFACT_ID_ELEMENT, true);
                            String version = this.getChildParameterValue((Xpp3Dom)lib, "version", true);
                            additionalDependency.setArtifactId(additionalDependencyArtifactId);
                            additionalDependency.setGroupId(additionalDependencyGroupId);
                            additionalDependency.setVersion(version);
                            additionalDependencies.add(additionalDependency);
                        });
                        dependency.setAdditionalDependencies(additionalDependencies);
                        plugins.add(dependency);
                    }
                });
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Unable to get sharedLibraries from mule-maven-plugin");
        }
        return plugins;
    }

    private List<SharedLibraryDependency> getSharedLibraries() {
        Vector<SharedLibraryDependency> sharedLibraries = new Vector<SharedLibraryDependency>();
        try {
            Xpp3Dom sharedLibrariesElement;
            Xpp3Dom configuration;
            Plugin plugin = this.project.getPlugin(MULE_MAVEN_PLUGIN_KEY);
            if (plugin != null && (configuration = (Xpp3Dom)plugin.getConfiguration()) != null && (sharedLibrariesElement = configuration.getChild(SHARED_LIBRARIES_KEY)) != null) {
                Xpp3Dom[] libraries = sharedLibrariesElement.getChildren();
                Arrays.stream(libraries).forEach(library -> {
                    String pluginGroupId = this.getChildParameterValue((Xpp3Dom)library, GROUP_ID_ELEMENT, true);
                    String pluginArtifactId = this.getChildParameterValue((Xpp3Dom)library, ARTIFACT_ID_ELEMENT, true);
                    SharedLibraryDependency sharedLib = new SharedLibraryDependency();
                    sharedLib.setArtifactId(pluginArtifactId);
                    sharedLib.setGroupId(pluginGroupId);
                    sharedLibraries.add(sharedLib);
                });
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Unable to get sharedLibraries from mule-maven-plugin");
        }
        return sharedLibraries;
    }

    private void checkCoverage() throws MojoExecutionException {
        try {
            if (Objects.isNull(this.coverage)) {
                this.coverage = new Coverage();
            }
            if (Objects.nonNull(System.getProperty("munit.coverage.runCoverage"))) {
                this.coverage.setRunCoverage(Boolean.parseBoolean((String)this.expressionEvaluator.evaluate("${munit.coverage.runCoverage}")));
            }
            if (Objects.nonNull(System.getProperty("munit.coverage.formats"))) {
                this.coverage.setFormats(Optional.ofNullable((String)this.expressionEvaluator.evaluate("${munit.coverage.formats}")).map(String.class::cast).map(value -> value.split(",")).map(Arrays::asList).orElseGet(Collections::emptyList));
            }
        }
        catch (Exception exception) {
            throw new MojoExecutionException((Throwable)exception);
        }
    }
}

