/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.mule.munit.Coverage;
import org.mule.munit.coverage.MavenConsolePrinter;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.CoverageLimits;
import org.mule.munit.plugins.coverage.report.printer.CoverageReportPrinter;
import org.mule.munit.plugins.coverage.report.printer.HtmlPrinter;
import org.mule.munit.plugins.coverage.report.printer.JsonPrinter;
import org.mule.munit.plugins.coverage.report.printer.SonarPrinter;

@Mojo(name="coverage-report", defaultPhase=LifecyclePhase.TEST)
@Execute(lifecycle="munit", phase=LifecyclePhase.TEST)
public class MUnitCoverageReportMojo
extends AbstractMojo
implements MavenMultiPageReport {
    private static final String WONT_GENERATE_REPORT_MESSAGE = "This report cannot be generated as part of the current build";
    private static final String MUNIT_FOLDER = "munit";
    private static final String COVERAGE_FOLDER = "coverage";
    @Parameter(defaultValue="${project.build.directory}/site/munit/coverage/")
    protected File outputDirectory;
    @Parameter(property="munit.coverageConfigData", defaultValue="${project.build.directory}/munit-reports/coverage-config.data")
    protected File coverageConfigDataFile;
    @Parameter(property="munit.coverageReportData", defaultValue="${project.build.directory}/munit-reports/coverage-report.data")
    protected File coverageReportDataFile;

    public boolean canGenerateReport() {
        return this.coverageConfigDataFile.exists() && this.coverageReportDataFile.exists();
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            this.doGenerateReport(Locale.getDefault(), this.readCoverageReportData(), this.readCoverageConfigurationData());
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.getDefault()) + " report generation.", (Exception)((Object)e));
        }
    }

    public boolean isExternalReport() {
        try {
            return this.hasHtmlFormat(this.readCoverageConfigurationData());
        }
        catch (MavenReportException e) {
            return false;
        }
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"This report cannot be generated as part of the current build: Coverage data is missing");
            return;
        }
        Coverage coverageConfig = this.readCoverageConfigurationData();
        if (!this.hasHtmlFormat(coverageConfig)) {
            this.getLog().warn((CharSequence)"This report cannot be generated as part of the current build: Html format is not present in the plugin configuration");
            this.generateWarningHtml(sink);
            return;
        }
        this.doGenerateReport(locale, this.readCoverageReportData(), coverageConfig);
        sink.close();
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        this.doGenerateReport(locale, this.readCoverageReportData(), this.readCoverageConfigurationData());
        sink.close();
    }

    public String getOutputName() {
        return "munit/coverage/summary";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return "MUnit Coverage";
    }

    public String getDescription(Locale locale) {
        return "MUnit - Coverage Report";
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && (!reportOutputDirectory.getParentFile().getName().equals(MUNIT_FOLDER) || !reportOutputDirectory.getName().equals(COVERAGE_FOLDER)) ? reportOutputDirectory.toPath().resolve(MUNIT_FOLDER).resolve(COVERAGE_FOLDER).toFile() : reportOutputDirectory;
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    protected Set<CoverageReportPrinter> buildPrinters(Coverage coverageConfiguration) {
        if (coverageConfiguration == null || coverageConfiguration.getFormats() == null) {
            return Collections.emptySet();
        }
        HashSet<CoverageReportPrinter> printers = new HashSet<CoverageReportPrinter>();
        this.outputDirectory.mkdirs();
        CoverageLimits limits = new CoverageLimits(coverageConfiguration.getRequiredApplicationCoverage(), coverageConfiguration.getRequiredResourceCoverage(), coverageConfiguration.getRequiredFlowCoverage());
        for (String printFormat : coverageConfiguration.getFormats()) {
            if ("Console".toLowerCase().equals(printFormat.toLowerCase())) {
                printers.add((CoverageReportPrinter)new MavenConsolePrinter(this.getLog()));
                continue;
            }
            if ("HTML".toLowerCase().equals(printFormat.toLowerCase())) {
                printers.add((CoverageReportPrinter)new HtmlPrinter(limits, this.outputDirectory));
                continue;
            }
            if ("Json".toLowerCase().equals(printFormat.toLowerCase())) {
                printers.add((CoverageReportPrinter)new JsonPrinter(limits, new File(this.outputDirectory, "munit-coverage.json")));
                continue;
            }
            if ("SONAR".toLowerCase().equals(printFormat.toLowerCase())) {
                printers.add((CoverageReportPrinter)new SonarPrinter(limits, new File(this.outputDirectory, "sonar.xml")));
                continue;
            }
            this.getLog().debug((CharSequence)("No report format find for: " + printFormat));
        }
        return printers;
    }

    protected void doGenerateReport(Locale locale, ApplicationCoverageReport coverageReport, Coverage coverageConfiguration) throws MavenReportException {
        if (coverageReport == null) {
            this.getLog().warn((CharSequence)"This report cannot be generated as part of the current build: Coverage data not found");
            return;
        }
        Set<CoverageReportPrinter> printers = this.buildPrinters(coverageConfiguration);
        printers.forEach(printer -> {
            this.getLog().info((CharSequence)("Generating: " + printer.getPrinterName() + " report..."));
            printer.printReport(coverageReport);
        });
    }

    protected Coverage readCoverageConfigurationData() throws MavenReportException {
        return this.readFileToClass(this.coverageConfigDataFile, Coverage.class);
    }

    protected ApplicationCoverageReport readCoverageReportData() throws MavenReportException {
        return this.readFileToClass(this.coverageReportDataFile, ApplicationCoverageReport.class);
    }

    private void generateWarningHtml(Sink sink) {
        sink.text("To enable the Html Coverage Report, add the html format to the plugin configuration");
        sink.close();
    }

    private <T> T readFileToClass(File dataFile, Class<T> clazz) throws MavenReportException {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(dataFile), StandardCharsets.UTF_8);
            Object coverageReport = new Gson().fromJson((Reader)reader, clazz);
            reader.close();
            return (T)coverageReport;
        }
        catch (IOException e) {
            throw new MavenReportException("An error occurred while reading the report data", (Exception)e);
        }
    }

    private boolean hasHtmlFormat(Coverage coverageConfig) {
        return coverageConfig != null && coverageConfig.getFormats() != null && coverageConfig.getFormats().stream().anyMatch("HTML"::equalsIgnoreCase);
    }
}

