/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.common.util.FreePortFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertiesManager {
    private static final int MIN_PORT_NUMBER = 40000;
    private static final int MAX_PORT_NUMBER = 50000;
    private static final Collection<String> INVALID_SYSTEM_PROPERTIES = Arrays.asList("java.library.path", "file.encoding", "jdk.map.althashing.threshold");
    private List<String> dynamicPorts;
    private Map<String, String> systemPropertyVariables;
    private Properties userProperties;
    private File muleWorkingDir;
    private Log log;

    public SystemPropertiesManager(Map<String, String> systemPropertyVariables, List<String> dynamicPorts, Properties userProperties, File muleWorkingDir, Log log) {
        this.systemPropertyVariables = systemPropertyVariables;
        this.dynamicPorts = dynamicPorts;
        this.userProperties = userProperties;
        this.muleWorkingDir = muleWorkingDir;
        this.log = log;
    }

    public Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        this.setSystemPropertyVariables(effectiveSystemProperties);
        this.setDynamicPorts(effectiveSystemProperties);
        this.stopLicenseCheck(effectiveSystemProperties);
        this.setMuleWorkingDir(effectiveSystemProperties);
        this.setUserSystemProperties(effectiveSystemProperties);
        this.removeInvalidSystemProperties(effectiveSystemProperties);
        return effectiveSystemProperties;
    }

    private void stopLicenseCheck(Map<String, String> props) {
        this.log.debug((CharSequence)"Avoid license check for Mule EE components...");
        props.put("mule.testingMode", "true");
    }

    private void setMuleWorkingDir(Map<String, String> props) {
        if (this.muleWorkingDir != null) {
            try {
                this.log.info((CharSequence)("Mule working directory set to: " + this.muleWorkingDir));
                props.put("mule.working.dir", this.muleWorkingDir.getCanonicalPath());
            }
            catch (IOException e) {
                this.log.debug((CharSequence)"Unable to set the Mule working directory", (Throwable)e);
            }
        }
    }

    private void setSystemPropertyVariables(Map<String, String> systemProperties) {
        if (this.systemPropertyVariables != null) {
            systemProperties.putAll(this.systemPropertyVariables);
            this.log.debug((CharSequence)("Adding System Property Variables : " + this.systemPropertyVariables));
        }
    }

    private void setUserSystemProperties(Map<String, String> systemProperties) {
        if (this.userProperties != null) {
            for (Map.Entry<Object, Object> prop : this.userProperties.entrySet()) {
                Object key = prop.getKey();
                Object value = prop.getValue();
                if (!(key instanceof String) || !(value instanceof String)) continue;
                systemProperties.put(prop.getKey().toString(), prop.getValue().toString());
                this.log.debug((CharSequence)String.format("Setting System Property [%s] to %s", key, value));
            }
        }
    }

    private void setDynamicPorts(Map<String, String> systemProperties) {
        if (this.dynamicPorts != null) {
            this.log.info((CharSequence)"Acquiring dynamic ports...");
            FreePortFinder portFinder = new FreePortFinder(40000, 50000);
            for (String portPlaceHolder : this.dynamicPorts) {
                Integer dynamicPort = portFinder.find();
                systemProperties.put(portPlaceHolder, dynamicPort.toString());
                this.log.debug((CharSequence)String.format("Dynamic port [%s] set to: [%s]", portPlaceHolder, dynamicPort));
            }
            this.log.info((CharSequence)"Dynamic port definition [DONE]");
        }
    }

    private void removeInvalidSystemProperties(Map<String, String> effectiveSystemProperties) {
        for (String invalidProp : INVALID_SYSTEM_PROPERTIES) {
            if (!effectiveSystemProperties.containsKey(invalidProp)) continue;
            effectiveSystemProperties.remove(invalidProp);
            this.log.warn((CharSequence)(invalidProp + " cannot be set as system property, use <argLine>-D" + invalidProp + "=...</argLine> instead"));
        }
    }
}

