/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.mule.Coverage;
import org.mule.coverage.CoverageManager;
import org.mule.munit.remote.RemoteRunner;
import org.mule.runner.ErrorStreamConsumer;
import org.mule.runner.JVMStarter;
import org.mule.runner.RunnerStreamConsumer;
import org.mule.runner.StartupConfiguration;
import org.mule.runner.handler.RunnerMessageHandler;
import org.mule.runner.handler.StandardOutputMessageHandler;
import org.mule.runner.handler.TestOutputMessageHandler;
import org.mule.runner.model.RunResult;
import org.mule.runner.printer.MavenResultPrinter;
import org.mule.runner.printer.ResultPrinter;
import org.mule.runner.printer.TestOutputPrinter;
import org.mule.runner.printer.TextResultPrinter;
import org.mule.runner.printer.XmlResultPrinter;
import org.mule.util.ClasspathManager;
import org.mule.util.MulePropertiesLoader;
import org.mule.util.SystemPropertiesManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class MUnitMojo
extends AbstractMojo {
    public static final String SINGLE_TEST_NAME_TOKEN = "#";
    private static final Class REMOTE_RUNNER_CLASS = RemoteRunner.class;
    private static final String[] MUNIT_SUITE_EXTENSIONS = new String[]{"xml"};
    private static final String SKIP_TESTS_PROPERTY = "skipTests";
    private static final String SKIP_MUNIT_TESTS_PROPERTY = "skipMunitTests";
    private static final String SKIP_ZIP_LOADING_PROPERTY = "skipZipLoading";
    protected String testToRunName;
    @Parameter(property="project", required=true)
    protected MavenProject project;
    @Parameter(property="munit.test")
    protected String munittest;
    @Deprecated
    @Parameter(property="log.to.file", defaultValue="false")
    protected boolean logToFile;
    @Parameter(property="system.property.variables")
    protected Map<String, String> systemPropertyVariables;
    @Parameter(property="environment.variables")
    protected Map<String, String> environmentVariables;
    @Parameter(property="dynamic.ports")
    protected List<String> dynamicPorts;
    @Parameter(property="project.testClasspathElements", required=true, readonly=true)
    protected List<String> classpathElements;
    @Parameter(property="munit.coverage")
    protected Coverage coverage;
    @Parameter(property="argLines")
    protected List<String> argLines;
    @Parameter(property="additionalClasspathElements")
    protected List<String> additionalClasspathElements;
    @Parameter(property="classpathDependencyExcludes")
    protected List<String> classpathDependencyExcludes;
    @Parameter(defaultValue="${project.basedir}/src/test/munit/")
    protected File munitTestsDirectory;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/")
    protected File munitReportsDirectory;
    @Parameter(property="redirectTestOutputToFile", defaultValue="false")
    protected boolean redirectTestOutputToFile;
    @Parameter(defaultValue="${project.build.directory}/munit-reports/output/")
    protected File testOutputDirectory;
    @Parameter(property="enableSurefireReports", defaultValue="true")
    protected boolean enableSurefireReports;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    protected File surefireReportsFolder;
    @Parameter(defaultValue="${project.build.directory}/.mule")
    protected File muleWorkingDirectory;
    @Component
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty(SKIP_TESTS_PROPERTY))) {
            if (!"true".equals(System.getProperty(SKIP_MUNIT_TESTS_PROPERTY))) {
                this.doExecute();
            } else {
                this.getLog().info((CharSequence)"Run of munit-maven-plugin skipped. Property [skipMunitTests] was set to true");
            }
        } else {
            this.getLog().info((CharSequence)"Run of munit-maven-plugin skipped. Property [skipTests] was set to true");
        }
    }

    private void doExecute() throws MojoExecutionException {
        if (this.logToFile) {
            this.getLog().debug((CharSequence)"The property log.to.file is deprecated and will stop working in MUnit 2.0.0, check redirectTestOutputToFile. Please remove it from your plugin configuration.");
        }
        this.parseTestFilter();
        CoverageManager coverageManager = this.buildCoverageManager();
        try {
            RunResult runResult;
            StartupConfiguration startupConfiguration = this.createStartupConfiguration(coverageManager);
            if (startupConfiguration == null) {
                return;
            }
            if (startupConfiguration.getSuites().isEmpty()) {
                this.getLog().info((CharSequence)"No MUnit suite files were found to run");
                return;
            }
            RunnerStreamConsumer streamConsumer = new RunnerStreamConsumer(this.buildMessageHandlers());
            ErrorStreamConsumer errorStreamConsumer = new ErrorStreamConsumer(this.redirectTestOutputToFile);
            JVMStarter jvmStarter = new JVMStarter(startupConfiguration, this.getLog());
            int result = jvmStarter.execute(streamConsumer, (StreamConsumer)errorStreamConsumer);
            if (result == 0) {
                runResult = streamConsumer.getRunResult();
                coverageManager.setReport(runResult.getApplicationCoverageReport());
                coverageManager.printReport();
                for (ResultPrinter printer : this.getResultPrinters(startupConfiguration)) {
                    printer.print(runResult);
                }
            } else {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoExecutionException(errorStreamConsumer.getOutput()));
            }
            boolean resultSuccess = !runResult.hasFailed();
            if (!resultSuccess) {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoExecutionException("MUnit Tests Failed"));
            }
            if (coverageManager.failBuild().booleanValue()) {
                throw new MojoExecutionException("Build Fail", (Exception)new MojoFailureException("Coverage limits were not reached"));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
    }

    private RunnerMessageHandler buildMessageHandlers() {
        if (this.redirectTestOutputToFile) {
            return new TestOutputMessageHandler(this.getLog());
        }
        return new StandardOutputMessageHandler();
    }

    private List<ResultPrinter> getResultPrinters(StartupConfiguration startupConfiguration) {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new MavenResultPrinter(this.getLog()));
        if (this.enableSurefireReports) {
            printers.addAll(this.getSurefireResultPrinters(startupConfiguration));
        }
        if (this.redirectTestOutputToFile) {
            printers.add(new TestOutputPrinter(this.testOutputDirectory, this.munitTestsDirectory, this.project.getBasedir(), this.getLog()));
        }
        return printers;
    }

    private List<ResultPrinter> getSurefireResultPrinters(StartupConfiguration startupConfiguration) {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new XmlResultPrinter(this.surefireReportsFolder, this.munitTestsDirectory, this.project.getBasedir(), startupConfiguration.getSystemProperties(), this.getLog()));
        printers.add(new TextResultPrinter(this.surefireReportsFolder, this.munitTestsDirectory, this.project.getBasedir(), this.getLog()));
        if (this.redirectTestOutputToFile) {
            printers.add(new TestOutputPrinter(this.surefireReportsFolder, this.munitTestsDirectory, this.project.getBasedir(), this.getLog()));
        }
        return printers;
    }

    private StartupConfiguration createStartupConfiguration(CoverageManager coverageManager) throws MojoExecutionException, FileNotFoundException {
        if (!this.munitTestsDirectory.exists()) {
            this.getLog().warn((CharSequence)("The project has no " + this.munitTestsDirectory + " folder. Aborting MUnit test run."));
            return null;
        }
        this.getLog().debug((CharSequence)("MUnit root folder found at: " + this.munitTestsDirectory.getAbsolutePath()));
        List<File> allFiles = this.getMunitTestSuiteFileList();
        StartupConfiguration startupConfiguration = new StartupConfiguration();
        startupConfiguration.setRunToken(UUID.randomUUID().toString());
        startupConfiguration.setBuildDirectory(this.project.getBuild().getDirectory());
        startupConfiguration.setClassName(REMOTE_RUNNER_CLASS.getCanonicalName());
        startupConfiguration.setClasspath(this.getEffectiveClassPath());
        startupConfiguration.setJvm(this.getEffectiveJvm());
        startupConfiguration.setWorkingDirectory(this.getWorkingDirectory());
        startupConfiguration.setSystemProperties(this.getEffectiveSystemProperties());
        startupConfiguration.setSuites(allFiles);
        startupConfiguration.setTest(this.testToRunName);
        startupConfiguration.setArgLines(this.argLines);
        startupConfiguration.setEnvironmentVariables(this.environmentVariables);
        coverageManager.setClasspath(startupConfiguration.getClasspath());
        startupConfiguration.setRunCoverage(coverageManager.shouldRunCoverage());
        startupConfiguration.setApplicationPaths(this.getConfigResources());
        startupConfiguration.setProjectName(this.getProjectName());
        startupConfiguration.setIgnoreFlows(coverageManager.getIgnoredFlows());
        return startupConfiguration;
    }

    private Map<String, String> getEffectiveSystemProperties() {
        SystemPropertiesManager systemPropertiesManager = new SystemPropertiesManager(this.systemPropertyVariables, this.dynamicPorts, this.session != null ? this.session.getUserProperties() : null, this.muleWorkingDirectory, this.getLog());
        return systemPropertiesManager.getEffectiveSystemProperties();
    }

    private List<String> getEffectiveClassPath() throws MojoExecutionException {
        ClasspathManager classpathManager = new ClasspathManager(this.classpathElements, this.getZipDependencies(), this.additionalClasspathElements, this.classpathDependencyExcludes, this.project.getArtifacts(), REMOTE_RUNNER_CLASS, this.getLog());
        return classpathManager.getEffectiveClasspath();
    }

    private CoverageManager buildCoverageManager() {
        CoverageManager coverageManager = new CoverageManager(this.coverage, this.munitReportsDirectory, this.getLog());
        this.getLog().debug((CharSequence)String.format("Coverage Manager Build for project: %s - %s", this.getProjectName(), this.project.getBasedir()));
        this.getLog().debug((CharSequence)this.project.getBuild().getDirectory());
        return coverageManager;
    }

    private List<File> getMunitTestSuiteFileList() throws FileNotFoundException {
        ArrayList<File> munitTestSuiteFiles = new ArrayList<File>();
        Collection allFiles = FileUtils.listFiles((File)this.munitTestsDirectory, (String[])MUNIT_SUITE_EXTENSIONS, (boolean)true);
        for (File file : allFiles) {
            String fileName = file.getPath().replace(this.munitTestsDirectory.getPath() + File.separator, "");
            if (!this.isValidMunitTestSuiteFile(file)) continue;
            if (this.validateFilter(fileName)) {
                munitTestSuiteFiles.add(file);
                continue;
            }
            this.getLog().debug((CharSequence)String.format("MUnit Test Suite file %s skipped. It doesn't match filter criteria: [%s]", fileName, this.munittest));
        }
        return munitTestSuiteFiles;
    }

    private boolean isValidMunitTestSuiteFile(File file) throws FileNotFoundException {
        String MUNIT_TEST_SUITE_FILE_MARKER = "munit:config";
        Scanner scanner = new Scanner(file);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.contains(MUNIT_TEST_SUITE_FILE_MARKER)) continue;
            scanner.close();
            return true;
        }
        scanner.close();
        return false;
    }

    private String getConfigResources() {
        MulePropertiesLoader propertiesLoader = new MulePropertiesLoader(this.project.getBuild().getOutputDirectory(), this.project.getBuild().getTestOutputDirectory(), this.getLog());
        return propertiesLoader.getConfigResources();
    }

    private String getProjectName() {
        return this.project.getArtifactId();
    }

    private void parseTestFilter() {
        if (StringUtils.isNotBlank((String)this.munittest) && this.munittest.contains(SINGLE_TEST_NAME_TOKEN)) {
            this.testToRunName = this.munittest.substring(this.munittest.indexOf(SINGLE_TEST_NAME_TOKEN) + 1);
            this.munittest = this.munittest.substring(0, this.munittest.indexOf(SINGLE_TEST_NAME_TOKEN));
        } else {
            this.testToRunName = "";
        }
    }

    private boolean validateFilter(String fileName) {
        return this.munittest == null || fileName.matches(this.munittest);
    }

    private List<String> getZipDependencies() {
        if ("true".equals(System.getProperty(SKIP_ZIP_LOADING_PROPERTY))) {
            this.getLog().debug((CharSequence)"Skipping loading of zip dependencies. Property [skipZipLoading] was set to true");
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> zipDependencies = new ArrayList<String>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact a : artifacts) {
            if (!a.getFile().getPath().endsWith(".zip")) continue;
            this.getLog().debug((CharSequence)("Loading artifact[" + a.getFile().getPath() + "]"));
            zipDependencies.add(a.getFile().getPath());
        }
        return zipDependencies;
    }

    private File getWorkingDirectory() {
        if (this.project != null) {
            return this.project.getBasedir();
        }
        return new File(".");
    }

    private String getEffectiveJvm() {
        String jvm = "";
        Toolchain toolchain = this.getToolchain();
        if (toolchain != null) {
            jvm = toolchain.findTool("java");
        }
        if (StringUtils.isEmpty((String)jvm)) {
            jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        this.getLog().debug((CharSequence)("Using JVM: " + jvm));
        return jvm;
    }

    private Toolchain getToolchain() {
        Toolchain toolchain = null;
        if (this.toolchainManager != null && this.session != null) {
            toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return toolchain;
    }
}

