/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.tools.assertion;

import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.assertion.api.MunitAssertion;
import org.mule.munit.assertion.api.expression.MatcherResult;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.internal.AssertModule;
import org.mule.munit.assertion.internal.HamcrestFactory;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.tools.MunitToolsErrorDefinition;
import org.mule.munit.tools.assertion.AssertionErrorProvider;
import org.mule.munit.tools.assertion.InvalidAssertionExpressionException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertOperations {
    private static final String RUN_CUSTOM_INTERFACE_ERROR = "The run-custom operation requires a class implementing %s. Please provide one.";
    private static final String RUN_CUSTOM_ERROR = "Unable to create custom assertion";
    private static final String MUNIT_ASSERTION_CLASS = "org.mule.munit.assertion.api.MunitAssertion";
    private static final String DEFAULT_ASSERT_CONTENT = "#[import * from dw::test::Asserts \n ---\npayload must notBeNull()]";
    private static final String LOCATION_MESSAGE = " at file: [%s], line: [%d]";
    private static final String MUNIT_BINDING_NAME = "munit_equal_to_placeholder";
    private static final String EQUAL_TO_WRAPPER = "#[MunitTools::equalTo(munit_equal_to_placeholder)]";
    private static final DataType MATCHER_DATA_TYPE = DataType.fromType(Matcher.class);
    private static final Logger logger = LoggerFactory.getLogger(AssertOperations.class);
    private AssertModule assertModule = new AssertModule();
    @Inject
    public ExpressionManager expressionManager;

    @Throws(value={AssertionErrorProvider.class})
    @Summary(value="Perform an assertion over an expression")
    public void assertThat(@Example(value="#[payload]") TypedValue<Object> expression, @Expression(value=ExpressionSupport.REQUIRED) @Example(value="#[MunitTools::notNullValue()]") Matcher is, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="") String message, ComponentLocation location) {
        this.munitAssert(message, location, this.validateExpression(expression), is);
    }

    private TypedValue<Object> validateExpression(TypedValue<Object> expression) {
        if (!expression.getDataType().isStreamType() || expression.getDataType() instanceof CollectionDataType) {
            return expression;
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)((CursorStream)expression.getValue()));
            DataType dataType = DataType.builder((DataType)expression.getDataType()).type(bytes.getClass()).build();
            return new TypedValue((Object)bytes, dataType, expression.getByteLength());
        }
        catch (Exception e) {
            logger.warn("Failed to convert 'expression' to byte[], returning the original value: ", (Throwable)e);
            return expression;
        }
    }

    @Summary(value="Asserts that an expression is successful")
    @DisplayName(value="Assert expression")
    @Alias(value="assert")
    @Throws(value={AssertionErrorProvider.class})
    public void assertExpression(@DisplayName(value="Expression") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[import * from dw::test::Asserts \n ---\npayload must notBeNull()]") @Content ParameterResolver<Map<String, Object>> that, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="Assertion failed") String message, ComponentLocation location) {
        try {
            MatcherResult matcherResult = (MatcherResult)MatcherResult.validateAndCreate((Map)((Map)that.resolve())).orElseThrow(() -> new InvalidAssertionExpressionException(that.getExpression().orElse("")));
            this.assertModule.assertMatcherResult(matcherResult, message + this.locationMessage(location));
        }
        catch (ExpressionRuntimeException e) {
            if (e.getMessage().contains("to class") || e.getMessage().contains("Cannot coerce")) {
                throw new InvalidAssertionExpressionException(that.getExpression().orElse(""), e);
            }
            throw e;
        }
    }

    @Summary(value="Check if an expression is equal to a value")
    @Throws(value={AssertionErrorProvider.class})
    public void assertEquals(@Example(value="#[payload]") TypedValue<Object> actual, @ParameterDsl(allowReferences=false) @Example(value="#['EXAMPLE']") TypedValue<Object> expected, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="") String message, ComponentLocation location) {
        BindingContext bindingContext = BindingContext.builder().addBinding(MUNIT_BINDING_NAME, expected).build();
        Matcher equalToMatcher = (Matcher)this.expressionManager.evaluate(EQUAL_TO_WRAPPER, MATCHER_DATA_TYPE, bindingContext).getValue();
        this.munitAssert(message, location, actual, equalToMatcher);
    }

    @Summary(value="Fail with an assertion")
    @Throws(value={AssertionErrorProvider.class})
    public void fail(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="") String message) {
        throw Optional.ofNullable(message).map(m -> new ModuleException(m, (ErrorTypeDefinition)MunitToolsErrorDefinition.ASSERTION_ERROR)).orElseGet(() -> new ModuleException("", (ErrorTypeDefinition)MunitToolsErrorDefinition.ASSERTION_ERROR));
    }

    @Summary(value="Run a custom assertion")
    public void runCustom(@Example(value="com.example.CustomAssertion") @ClassValue(extendsOrImplements={"org.mule.munit.assertion.api.MunitAssertion"}) String assertion, @Example(value="#[payload]") TypedValue<Object> expression, @org.mule.runtime.extension.api.annotation.param.Optional Object params) {
        if (StringUtils.isBlank((CharSequence)assertion)) {
            throw new MunitError(String.format(RUN_CUSTOM_INTERFACE_ERROR, MUNIT_ASSERTION_CLASS));
        }
        try {
            MunitAssertion munitAssertion = (MunitAssertion)Class.forName(assertion).newInstance();
            munitAssertion.execute(org.mule.munit.assertion.api.TypedValue.fromMuleTypedValue(expression), params);
        }
        catch (ClassCastException e) {
            throw new MunitError(String.format(RUN_CUSTOM_INTERFACE_ERROR, MUNIT_ASSERTION_CLASS));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MunitError(RUN_CUSTOM_ERROR, (Throwable)e);
        }
    }

    private void munitAssert(String message, ComponentLocation location, TypedValue<Object> expression, Matcher is) {
        try {
            this.assertModule.assertThat(message + this.locationMessage(location), expression, HamcrestFactory.create((Matcher)is));
        }
        catch (AssertionError e) {
            throw new ModuleException((ErrorTypeDefinition)MunitToolsErrorDefinition.ASSERTION_ERROR, (Throwable)((Object)e));
        }
    }

    protected void setAssertModule(AssertModule assertModule) {
        this.assertModule = assertModule;
    }

    private String locationMessage(ComponentLocation location) {
        return String.format(LOCATION_MESSAGE, location.getFileName().orElse("UNKNOWN"), location.getLineInFile().orElse(-1));
    }
}

