/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util.store;

import static java.util.Collections.singleton;
import static org.mule.munit.tools.MunitToolsErrorDefinition.KEY_ALREADY_EXISTS;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.Set;

/**
 * Errors for the {@code store-oauth-token} operation
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class StoreOAuthTokenErrorProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    return singleton(KEY_ALREADY_EXISTS);
  }

}
