/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.tools.util;

import static org.mule.munit.tools.MunitToolsErrorDefinition.SLEEP_INTERRUPT;
import org.mule.runtime.extension.api.exception.ModuleException;

/**
 * Exception thrown when an {@link InterruptedException} is thrown when performing sleep operation.
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class SleepInterruptedException extends ModuleException {

  public SleepInterruptedException() {
    super("Sleep operation was interrupted", SLEEP_INTERRUPT);
  }
}
