/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.api.model.stereotype.MUnitStereotypes;
import org.mule.munit.common.api.util.VersionUtils;
import org.mule.munit.common.protocol.listeners.SuiteRunEventListener;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.runner.component.TestComponent;
import org.mule.munit.runner.config.TestComponentLocator;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.model.Suite;
import org.mule.munit.runner.model.Test;
import org.mule.munit.runner.model.builders.TestRunFilter;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.munit.runner.remote.api.notifiers.DummySuiteRunEventListener;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.core.api.config.MuleManifest;

public class SuiteBuilder {
    private static BiFunction<ComponentAst, String, ComponentParameterAst> AST_PARAM_FETCHER;
    protected String suitePath;
    private final String parameterization;
    private final TestComponentLocator testComponentLocator;
    private final Optional<ArtifactAst> testArtifactAst;
    protected Set<String> tags;
    protected List<RunConfiguration.Test> testNames;
    protected SuiteRunEventListener suiteRunEventListener;

    public SuiteBuilder(String suitePath, String parameterization, TestComponentLocator testComponentLocator, Optional<ArtifactAst> testArtifactAst) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)suitePath), (String)"The suitePath must not be null nor empty");
        Preconditions.checkNotNull((Object)testComponentLocator, (String)"The test component locator must not be null");
        this.suitePath = suitePath;
        this.parameterization = parameterization;
        this.suiteRunEventListener = new DummySuiteRunEventListener();
        this.testComponentLocator = testComponentLocator;
        this.testArtifactAst = testArtifactAst;
    }

    public SuiteBuilder withTestNames(List<RunConfiguration.Test> testNames) {
        this.testNames = testNames;
        return this;
    }

    public SuiteBuilder withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public SuiteBuilder withSuiteRunnerEventListener(SuiteRunEventListener suiteRunEventListener) {
        Preconditions.checkNotNull((Object)suiteRunEventListener, (String)"The suiteRunEventListener must not be null");
        this.suiteRunEventListener = suiteRunEventListener;
        return this;
    }

    public Suite build() {
        Suite suite = new Suite(this.suitePath, this.parameterization);
        suite.setSuiteRunEventListener(this.suiteRunEventListener);
        if (this.testArtifactAst.isPresent()) {
            Product requiredProduct;
            ComponentAst munitModuleComponent = this.testArtifactAst.get().topLevelComponentsStream().filter(c -> c.getLocation().getFileName().map(this.suitePath::equals).orElse(false)).filter(c -> c.getIdentifier().equals(ComponentIdentifier.buildFromStringRepresentation((String)"munit:config"))).findAny().orElseThrow(() -> new IllegalStateException("Missing element [munit:config] in file " + this.suitePath));
            Optional<String> minMuleVersion = Optional.ofNullable((String)AST_PARAM_FETCHER.apply(munitModuleComponent, "minMuleVersion").getValue().getRight());
            String requiredProductName = (String)AST_PARAM_FETCHER.apply(munitModuleComponent, "requiredProduct").getValue().getRight();
            Product actualProduct = Product.getProductByName((String)MuleManifest.getProductName());
            String actualVersion = MuleManifest.getProductVersion();
            Product product = requiredProduct = requiredProductName != null ? Product.valueOf((String)requiredProductName) : Product.MULE;
            if (actualProduct.supports(requiredProduct) && minMuleVersion.map(mmv -> VersionUtils.isAtLeastMinMuleVersion((String)actualVersion, (String)mmv)).orElse(true).booleanValue()) {
                TestRunFilter filter = new TestRunFilter();
                if (this.testArtifactAst.get().topLevelComponentsStream().filter(c -> c.getLocation().getFileName().map(this.suitePath::equals).orElse(false)).anyMatch(c -> filter.shouldRunTest((String)c.getComponentId().get(), this.getTestTags((ComponentAst)c), this.testNames, this.tags, this.suitePath))) {
                    this.testComponentLocator.initializeComponents(this.suitePath);
                    MunitModule munitModule = this.testComponentLocator.lookupMunitModule().orElseThrow(() -> new IllegalStateException("Missing element [munit:config] in file " + this.suitePath));
                    suite.setBeforeSuite(this.testComponentLocator.lookupBeforeSuite().orElse(null));
                    this.createTests(munitModule, true, false).forEach(suite::addTest);
                    suite.setAfterSuite(this.testComponentLocator.lookupAfterSuite().orElse(null));
                }
            }
        } else {
            this.testComponentLocator.initializeComponents(this.suitePath);
            MunitModule munitModule = this.testComponentLocator.lookupMunitModule().orElseThrow(() -> new IllegalStateException("Missing element [munit:config] in file " + this.suitePath));
            suite.setBeforeSuite(this.testComponentLocator.lookupBeforeSuite().orElse(null));
            this.createTests(munitModule, true, true).forEach(suite::addTest);
            suite.setAfterSuite(this.testComponentLocator.lookupAfterSuite().orElse(null));
        }
        return suite;
    }

    private Set<String> getTestTags(ComponentAst testComponent) {
        Stream<String> implicitTags = testComponent.recursiveStream().map(c -> c.getModel(HasStereotypeModel.class).flatMap(hsm -> Optional.ofNullable(hsm.getStereotype()))).flatMap(s -> s.map(Stream::of).orElse(Stream.empty())).filter(stereotype -> stereotype.isAssignableTo(MUnitStereotypes.TEST_PROCESSOR)).map(stereotype -> stereotype.getNamespace() + ":" + stereotype.getType());
        ComponentParameterAst tagsParam = AST_PARAM_FETCHER.apply(testComponent, "tags");
        if (tagsParam == null) {
            return implicitTags.collect(Collectors.toSet());
        }
        Object tagsParamValue = tagsParam.getValue().getRight();
        if (tagsParamValue == null) {
            return implicitTags.collect(Collectors.toSet());
        }
        Stream<String> explicitTags = Stream.of(((String)tagsParamValue).split(","));
        return Stream.concat(implicitTags, explicitTags).collect(Collectors.toSet());
    }

    private List<Test> createTests(MunitModule munitModule, boolean doFilter, boolean filterByTag) {
        BeforeTest before = this.testComponentLocator.lookupBeforeTest().orElse(null);
        Collection<TestComponent> testComponents = this.testComponentLocator.lookupTests();
        AfterTest after = this.testComponentLocator.lookupAfterTest().orElse(null);
        TestRunFilter filter = new TestRunFilter();
        if (filterByTag) {
            return testComponents.stream().filter(testComponent -> !doFilter || filter.shouldRunTest(testComponent.getName(), testComponent.getTags(), this.testNames, this.tags, this.suitePath)).map(testComponent -> this.test(before, (TestComponent)testComponent, after, munitModule)).collect(Collectors.toList());
        }
        return testComponents.stream().filter(testComponent -> !doFilter || filter.shouldRunTest(testComponent.getName(), this.testNames, this.suitePath)).map(testComponent -> this.test(before, (TestComponent)testComponent, after, munitModule)).collect(Collectors.toList());
    }

    protected Test test(BeforeTest beforeTest, TestComponent test, AfterTest afterTest, MunitModule munitModule) {
        return new Test(beforeTest, test, afterTest, munitModule);
    }

    static {
        try {
            Method getParameterMethod = ComponentAst.class.getDeclaredMethod("getParameter", String.class, String.class);
            AST_PARAM_FETCHER = (comp, paramName) -> {
                try {
                    return (ComponentParameterAst)getParameterMethod.invoke(comp, "General", paramName);
                }
                catch (InvocationTargetException e) {
                    throw new MuleRuntimeException(e.getCause());
                }
                catch (IllegalAccessException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            try {
                Method getParameterMethod = ComponentAst.class.getDeclaredMethod("getParameter", String.class);
                AST_PARAM_FETCHER = (comp, paramName) -> {
                    try {
                        return (ComponentParameterAst)getParameterMethod.invoke(comp, paramName);
                    }
                    catch (InvocationTargetException e) {
                        throw new MuleRuntimeException(e.getCause());
                    }
                    catch (IllegalAccessException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"No compatible ArtifactAST library available"), (Throwable)e);
            }
        }
    }
}

