/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.functions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.munit.runner.functions.MuleVersionEqualToFunction;
import org.mule.munit.runner.functions.MuleVersionNewerThanFunction;
import org.mule.munit.runner.functions.MuleVersionPriorToFunction;
import org.mule.munit.runner.functions.OsEqualToFunction;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.privileged.el.GlobalBindingContextProvider;

public class MunitFunctionsBindingContextProvider
implements GlobalBindingContextProvider {
    @Inject
    @Named(value="_muleConfigurationAttributesResolver")
    private ConfigurationProperties configurationProperties;

    public BindingContext getBindingContext() {
        ModuleNamespace munitNamespace = new ModuleNamespace(new String[]{"Munit"});
        Map<String, TypedValue> bindings = this.getBindings();
        MunitExpressionModule expressionModule = new MunitExpressionModule(bindings, munitNamespace);
        return BindingContext.builder().addModule((ExpressionModule)expressionModule).build();
    }

    private Map<String, TypedValue> getBindings() {
        HashMap<String, TypedValue> bindings = new HashMap<String, TypedValue>();
        this.addOsFunctions(bindings);
        this.addMuleVersionFunctions(bindings);
        return bindings;
    }

    private void addOsFunctions(Map<String, TypedValue> bindings) {
        this.addFunction(bindings, "osEqualTo", new OsEqualToFunction(this.configurationProperties));
    }

    private void addMuleVersionFunctions(Map<String, TypedValue> bindings) {
        this.addFunction(bindings, "muleVersionPriorTo", new MuleVersionPriorToFunction());
        this.addFunction(bindings, "muleVersionNewerThan", new MuleVersionNewerThanFunction());
        this.addFunction(bindings, "muleVersionEqualTo", new MuleVersionEqualToFunction());
    }

    private void addFunction(Map<String, TypedValue> bindings, String name, ExpressionFunction function) {
        bindings.put(name, new TypedValue((Object)function, DataType.fromFunction((ExpressionFunction)function)));
    }

    private static class MunitExpressionModule
    implements ExpressionModule {
        private Map<String, TypedValue> bindings;
        private ModuleNamespace namespace;

        MunitExpressionModule(Map<String, TypedValue> bindings, ModuleNamespace namespace) {
            this.bindings = bindings;
            this.namespace = namespace;
        }

        public Collection<Binding> bindings() {
            return this.bindings.entrySet().stream().map(entry -> new Binding((String)entry.getKey(), (TypedValue)entry.getValue())).collect(Collectors.toList());
        }

        public Collection<String> identifiers() {
            return this.bindings.keySet();
        }

        public Optional<TypedValue> lookup(String identifier) {
            return Optional.ofNullable(this.bindings.get(identifier));
        }

        public ModuleNamespace namespace() {
            return this.namespace;
        }
    }
}

