/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.remote.runtime.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * Base class for marshalling an {@link org.mule.munit.remote.runtime.utils.AbstractMuleArtifactModel} instance to {@code JSON}
 * format and back
 * @param <T> Artifact Model
 *
 * @author Mulesoft Inc.
 * @since 1.0
 */
public abstract class AbstractMuleArtifactModelJsonSerializer<T extends AbstractMuleArtifactModel> {

  private final Gson gson = (new GsonBuilder()).setPrettyPrinting().create();

  public AbstractMuleArtifactModelJsonSerializer() {}

  public String serialize(T muleArtifactModel) {
    return this.gson.toJson(muleArtifactModel);
  }

  public T deserialize(String json) {
    return gson.fromJson(json, getParameterizedClass());
  }

  protected abstract Class<T> getParameterizedClass();
}
