/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties;

import org.jdom2.input.SAXBuilder;

/**
 * Utility class that creates different XML objects with external entity processing disabled
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class XmlUtils {

  public static SAXBuilder createSecureSAXBuilder() {
    SAXBuilder saxBuilder = new SAXBuilder();
    saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
    saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);

    return saxBuilder;
  }

}
