/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.server;

import java.io.Serializable;

import org.mule.munit.common.util.Preconditions;

class DefaultTypedComponentIdentifier implements TypedComponentIdentifier, Serializable {

  private static final long serialVersionUID = -6585884125494525933L;

  private ComponentIdentifier identifier;
  private TypedComponentIdentifier.ComponentType type;

  private DefaultTypedComponentIdentifier() {}

  @Override
  public ComponentIdentifier getIdentifier() {
    return identifier;
  }

  @Override
  public ComponentType getType() {
    return type;
  }

  public static class Builder implements TypedComponentIdentifier.Builder {

    private final DefaultTypedComponentIdentifier typedComponentIdentifier = new DefaultTypedComponentIdentifier();

    @Override
    public TypedComponentIdentifier.Builder identifier(ComponentIdentifier identifier) {
      typedComponentIdentifier.identifier = identifier;
      return this;
    }

    @Override
    public Builder type(ComponentType type) {
      typedComponentIdentifier.type = type;
      return this;
    }

    @Override
    public TypedComponentIdentifier build() {
      Preconditions.checkState(typedComponentIdentifier.identifier != null, "identifier cannot be null");
      Preconditions.checkState(typedComponentIdentifier.type != null,
                               "type cannot be null");
      return typedComponentIdentifier;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    DefaultTypedComponentIdentifier that = (DefaultTypedComponentIdentifier) o;

    if (!getIdentifier().equals(that.getIdentifier())) {
      return false;
    }
    return getType() == that.getType();
  }

  @Override
  public int hashCode() {
    int result = getIdentifier().hashCode();
    result = 31 * result + Integer.hashCode(getType().ordinal());
    return result;
  }

  @Override
  public String toString() {
    return "DefaultTypedComponentIdentifier{" +
        "identifier=" + identifier +
        ", type=" + type +
        '}';
  }
}
