/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.api.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;

public class AdditionalPluginDependencies {
    private final String groupId;
    private final String artifactId;
    private final List<BundleDescriptor> additionalDependencies;

    public AdditionalPluginDependencies(String groupId, String artifactId, List<BundleDescriptor> additionalDependencies) {
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.additionalDependencies = Collections.unmodifiableList(additionalDependencies);
    }

    public AdditionalPluginDependencies(AdditionalPluginDependencies old, List<BundleDescriptor> additionalDependencies) {
        this(old.getGroupId(), old.getArtifactId(), additionalDependencies);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public List<BundleDescriptor> getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalPluginDependencies that = (AdditionalPluginDependencies)o;
        return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId);
    }
}

