/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private static final String META_INF = "META-INF";
    private static final String MAVEN_PATH = "META-INF/maven";
    private static final String MULE_PLUGIN_POM = "pom.xml";

    public static URL getPomUrlFromJar(Path artifactFile) {
        try {
            List<URL> jarMavenUrls = FileUtils.getUrlsWithinJar(artifactFile, MAVEN_PATH);
            if (jarMavenUrls.isEmpty()) {
                throw new RuntimeException(String.format("No entries found in %s for artifact %s", MAVEN_PATH, artifactFile.getFileName().toString()));
            }
            Optional<URL> pomUrl = jarMavenUrls.stream().filter(url -> url.toString().endsWith(MULE_PLUGIN_POM)).findAny();
            if (!pomUrl.isPresent()) {
                String expectedPath = "META-INF/maven/${groupId}/${artifactId}/pom.xml";
                throw new RuntimeException(String.format("The file '%s' was missing while looking within the artifact %s (it should be placed under [%s]).%sFound URLs in Maven folder: %s", MULE_PLUGIN_POM, artifactFile.getFileName().toString(), expectedPath, jarMavenUrls));
            }
            return pomUrl.get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<byte[]> loadFileContentFrom(URL jarFile) throws IOException {
        Optional<byte[]> optional;
        block8: {
            JarURLConnection jarConnection = (JarURLConnection)jarFile.openConnection();
            jarConnection.setUseCaches(false);
            InputStream stream = jarConnection.getInputStream();
            try {
                optional = Optional.of(IOUtils.toByteArray((InputStream)stream));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    private static URL getUrlWithinJar(Path jarFile, String filePath) throws MalformedURLException {
        return new URL("jar:" + jarFile.toUri().toString() + "!/" + filePath);
    }

    private static List<URL> getUrlsWithinJar(Path file, String directory) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(file, new OpenOption[0]));){
            ZipEntry jarEntry = zis.getNextEntry();
            while (jarEntry != null) {
                String entryName = jarEntry.getName();
                if (!FileUtils.isValidJarEntryPath(entryName)) {
                    throw new IOException("Invalid jar entry path detected: " + entryName);
                }
                if (!jarEntry.isDirectory() && entryName.startsWith(directory + "/")) {
                    urls.add(FileUtils.getUrlWithinJar(file, entryName));
                }
                jarEntry = zis.getNextEntry();
            }
        }
        return urls;
    }

    private static boolean isValidJarEntryPath(String entryPath) {
        if (entryPath == null || entryPath.isEmpty()) {
            return false;
        }
        if (entryPath.contains("..")) {
            return false;
        }
        if (entryPath.startsWith("/") || entryPath.startsWith("\\")) {
            return false;
        }
        String normalizedPath = new File(entryPath).toPath().normalize().toString();
        return !normalizedPath.startsWith("..");
    }

    public static File newFile(String pathName) {
        try {
            return new File(pathName).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a canonical file for " + pathName, e);
        }
    }
}

