/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.exception;

import java.util.Objects;

public class ComparisonCompactor {
    private static final String ELLIPSIS = "...";
    private static final String DELTA_END = "]";
    private static final String DELTA_START = "[";
    private final int contextLength;
    private final String expected;
    private final String actual;
    private int prefix;
    private int suffix;

    private static String format(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null && message.length() > 0) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    public ComparisonCompactor(int contextLength, String expected, String actual) {
        this.contextLength = contextLength;
        this.expected = expected;
        this.actual = actual;
    }

    public String compact(String message) {
        if (this.expected == null || this.actual == null || this.areStringsEqual()) {
            return ComparisonCompactor.format(message, this.expected, this.actual);
        }
        this.findCommonPrefix();
        this.findCommonSuffix();
        String expected = this.compactString(this.expected);
        String actual = this.compactString(this.actual);
        return ComparisonCompactor.format(message, expected, actual);
    }

    private String compactString(String source) {
        String result = DELTA_START + source.substring(this.prefix, source.length() - this.suffix + 1) + DELTA_END;
        if (this.prefix > 0) {
            result = this.computeCommonPrefix() + result;
        }
        if (this.suffix > 0) {
            result = result + this.computeCommonSuffix();
        }
        return result;
    }

    private void findCommonPrefix() {
        this.prefix = 0;
        int end = Math.min(this.expected.length(), this.actual.length());
        while (this.prefix < end && this.expected.charAt(this.prefix) == this.actual.charAt(this.prefix)) {
            ++this.prefix;
        }
    }

    private void findCommonSuffix() {
        int expectedSuffix = this.expected.length() - 1;
        for (int actualSuffix = this.actual.length() - 1; actualSuffix >= this.prefix && expectedSuffix >= this.prefix && this.expected.charAt(expectedSuffix) == this.actual.charAt(actualSuffix); --actualSuffix, --expectedSuffix) {
        }
        this.suffix = this.expected.length() - expectedSuffix;
    }

    private String computeCommonPrefix() {
        return (this.prefix > this.contextLength ? ELLIPSIS : "") + this.expected.substring(Math.max(0, this.prefix - this.contextLength), this.prefix);
    }

    private String computeCommonSuffix() {
        int end = Math.min(this.expected.length() - this.suffix + 1 + this.contextLength, this.expected.length());
        return this.expected.substring(this.expected.length() - this.suffix + 1, end) + (this.expected.length() - this.suffix + 1 < this.expected.length() - this.contextLength ? ELLIPSIS : "");
    }

    private boolean areStringsEqual() {
        return Objects.equals(this.expected, this.actual);
    }
}

