/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.utils;

import java.lang.management.ManagementFactory;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JpmsUtils {
    public static final String JPMS_UTILS_MODULE_NAME = "org.mule.runtime.jpms.utils";
    public static final String MULE_SKIP_MODULE_TWEAKING_VALIDATION = "mule.module.tweaking.validation.skip";
    private static final Set<String> REQUIRED_ADD_MODULES = Collections.singleton("org.apache.commons.codec");
    private static final String REQUIRED_ADD_OPENS_JAVA_LANG = "--add-opens=java.base/java.lang=org.mule.runtime.embedded.api";
    private static final String REQUIRED_ADD_OPENS_JAVA_LANG_REFLECT = "--add-opens=java.base/java.lang.reflect=org.mule.runtime.embedded.api";
    private static final String REQUIRED_ADD_OPENS_JAVA_LANG_INVOKE = "--add-opens=java.base/java.lang.invoke=org.mule.runtime.embedded.api";
    private static final String REQUIRED_ADD_OPENS_JAVA_SQL = "--add-opens=java.sql/java.sql=org.mule.runtime.embedded.api";
    private static final String REQUIRED_ADD_OPENS_JAVAX_NAMING = "--add-opens=java.naming/javax.naming=org.mule.runtime.embedded.api";
    private static final String REQUIRED_ADD_OPENS_BOUNCY_CASTLE_SECURE_RANDOM = "--add-opens=java.base/sun.security.provider=org.bouncycastle.fips.core";
    private static final String REQUIRED_MUNIT_ADD_OPENS_JAVA_LANG = "--add-opens=java.base/java.lang=munit.starter";
    private static final String REQUIRED_MUNIT_ADD_OPENS_JAVA_LANG_REFLECT = "--add-opens=java.base/java.lang.reflect=munit.starter";
    private static final String REQUIRED_MUNIT_ADD_OPENS_JAVA_LANG_INVOKE = "--add-opens=java.base/java.lang.invoke=munit.starter";
    private static final String REQUIRED_MUNIT_ADD_OPENS_JAVA_SQL = "--add-opens=java.sql/java.sql=munit.starter";
    private static final String REQUIRED_MUNIT_ADD_OPENS_JAVAX_NAMING = "--add-opens=java.naming/javax.naming=munit.starter";
    private static final List<String> REQUIRED_ADD_OPENS = Arrays.asList("--add-opens=java.base/java.lang=org.mule.runtime.embedded.api", "--add-opens=java.base/java.lang.reflect=org.mule.runtime.embedded.api", "--add-opens=java.base/java.lang.invoke=org.mule.runtime.embedded.api", "--add-opens=java.sql/java.sql=org.mule.runtime.embedded.api", "--add-opens=java.naming/javax.naming=org.mule.runtime.embedded.api", "--add-opens=java.base/sun.security.provider=org.bouncycastle.fips.core", "--add-opens=java.base/java.lang=munit.starter", "--add-opens=java.base/java.lang.reflect=munit.starter", "--add-opens=java.base/java.lang.invoke=munit.starter", "--add-opens=java.sql/java.sql=munit.starter", "--add-opens=java.naming/javax.naming=munit.starter");

    public static void validateNoBootModuleLayerTweaking() {
        if (Boolean.getBoolean(MULE_SKIP_MODULE_TWEAKING_VALIDATION)) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.println("!! WARNING!");
            System.err.println("!! 'mule.module.tweaking.validation.skip' property MUST ONLY be used temporarily in development environments.");
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        JpmsUtils.doValidateArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    static void doValidateArguments(List<String> arguments) {
        List illegalAddModules = arguments.stream().filter(arg -> arg.startsWith("--add-modules=")).flatMap(addModules -> Stream.of(addModules.split("=")[1].split(","))).filter(moduleName -> REQUIRED_ADD_MODULES.stream().noneMatch(moduleName::equals)).collect(Collectors.toList());
        if (!illegalAddModules.isEmpty()) {
            throw new IllegalArgumentException("Invalid module tweaking options passed to the JVM running the Mule Runtime: --add-modules=" + String.valueOf(illegalAddModules));
        }
        List illegalArguments = arguments.stream().filter(arg -> arg.startsWith("--add-exports=") || arg.startsWith("--add-opens=") || arg.startsWith("--add-reads=") || arg.startsWith("--patch-module=")).filter(Predicate.not(REQUIRED_ADD_OPENS::contains)).collect(Collectors.toList());
        if (!illegalArguments.isEmpty()) {
            throw new IllegalArgumentException("Invalid module tweaking options passed to the JVM running the Mule Runtime: " + String.valueOf(illegalArguments));
        }
    }

    public static ClassLoader createJpmsUtilsClassLoader(URL jpmsUtilsLib) {
        ModuleFinder finder;
        try {
            finder = ModuleFinder.of(Paths.get(jpmsUtilsLib.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        ModuleLayer parent = ModuleLayer.boot();
        Set<String> roots = finder.findAll().stream().map(moduleRef -> moduleRef.descriptor().name()).collect(Collectors.toSet());
        Configuration configuration = parent.configuration().resolve(finder, ModuleFinder.ofSystem(), roots);
        ModuleLayer layer = parent.defineModulesWithOneLoader(configuration, JpmsUtils.class.getClassLoader());
        JpmsUtils.openToModule((ModuleLayer)layer, (String)JPMS_UTILS_MODULE_NAME, (String)"java.base", Arrays.asList("java.lang", "java.lang.reflect", "java.lang.invoke"));
        JpmsUtils.openToModule((ModuleLayer)layer, (String)JPMS_UTILS_MODULE_NAME, (String)"java.sql", Arrays.asList("java.sql"));
        JpmsUtils.openToModule((ModuleLayer)layer, (String)JPMS_UTILS_MODULE_NAME, (String)"java.naming", Arrays.asList("javax.naming"));
        return layer.findLoader(JPMS_UTILS_MODULE_NAME);
    }

    private static void openToModule(ModuleLayer layer, String moduleName, String bootModuleName, List<String> packages) {
        layer.findModule(moduleName).ifPresent(module -> ModuleLayer.boot().findModule(bootModuleName).ifPresent(bootModule -> {
            for (String pkg : packages) {
                bootModule.addOpens(pkg, (Module)module);
            }
        }));
    }
}

