/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.coverage.LocationGrouper;
import org.mule.munit.remote.coverage.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.model.CoverageComponentLocationReport;
import org.mule.munit.remote.coverage.model.MuleFlow;
import org.mule.munit.remote.coverage.model.MuleLocation;
import org.mule.munit.remote.coverage.model.MuleResource;
import org.mule.munit.remote.coverage.server.LocationPart;

public class ApplicationCoverageReportBuilder {
    private Set<String> suitePaths;
    private Set<String> flowsToIgnore = Collections.emptySet();
    private Set<String> filesToIgnore = Collections.emptySet();
    private Set<CoverageComponentLocationReport> allLocations;
    private Set<CoverageComponentLocationReport> coveredLocations;

    public ApplicationCoverageReportBuilder(Set<CoverageComponentLocationReport> allLocations, Set<CoverageComponentLocationReport> coveredLocations, Set<String> suitePaths) {
        Preconditions.checkNotNull(allLocations, "The set of locations must not be null");
        Preconditions.checkNotNull(coveredLocations, "The set of covered locations must not be null");
        Preconditions.checkNotNull(suitePaths, "The suite path list  must not be null");
        Preconditions.checkArgument(!suitePaths.isEmpty(), "The suite path list  must not be empty");
        this.allLocations = allLocations;
        this.coveredLocations = coveredLocations;
        this.suitePaths = suitePaths;
    }

    public void setFlowsToIgnore(Set<String> flowsToIgnore) {
        Preconditions.checkNotNull(flowsToIgnore, "The set of flows to ignore must not be null");
        this.flowsToIgnore = flowsToIgnore;
    }

    public void setFilesToIgnore(Set<String> filesToIgnore) {
        Preconditions.checkNotNull(filesToIgnore, "The set of files to ignore must not be null");
        this.filesToIgnore = filesToIgnore;
    }

    public Set<String> getSuitePaths() {
        return this.suitePaths;
    }

    public Set<String> getFlowsToIgnore() {
        return this.flowsToIgnore;
    }

    public Set<String> getFilesToIgnore() {
        return this.filesToIgnore;
    }

    public Set<CoverageComponentLocationReport> getCoveredLocations() {
        return this.coveredLocations;
    }

    public ApplicationCoverageReport build() {
        return new ApplicationCoverageReport(this.createMuleResources());
    }

    private List<MuleResource> createMuleResources() {
        Map<String, Set<CoverageComponentLocationReport>> locationsPerFile = new LocationGrouper(this.allLocations).groupByFile();
        return locationsPerFile.entrySet().stream().filter(location -> this.isNotIgnoredFile((String)location.getKey())).filter(location -> this.isNotSuiteFile((String)location.getKey())).map(location -> this.toMuleResource((String)location.getKey(), (Set)location.getValue())).collect(Collectors.toList());
    }

    private MuleResource toMuleResource(String fileName, Set<CoverageComponentLocationReport> fileLocations) {
        MuleResource muleResource = new MuleResource(fileName);
        muleResource.setFlows(this.createMuleFlows(fileLocations));
        return muleResource;
    }

    private List<MuleFlow> createMuleFlows(Set<CoverageComponentLocationReport> locations) {
        Map<LocationPart, Set<CoverageComponentLocationReport>> locationsPerFlow = new LocationGrouper(locations).groupByFlow();
        return locationsPerFlow.entrySet().stream().filter(location -> this.isNotIgnoredFlow((LocationPart)location.getKey())).map(location -> this.toMuleFlow((LocationPart)location.getKey(), (Set)location.getValue())).collect(Collectors.toList());
    }

    private MuleFlow toMuleFlow(LocationPart locationPart, Set<CoverageComponentLocationReport> flowLocations) {
        MuleFlow muleFlow = new MuleFlow(locationPart.getPartPath());
        muleFlow.setType(locationPart.getPartIdentifier().get().getType().toString());
        muleFlow.setLocations(flowLocations.stream().map(l -> this.toMuleLocation((CoverageComponentLocationReport)l)).collect(Collectors.toList()));
        muleFlow.setCoveredLocations(flowLocations.stream().filter(l -> this.coveredLocations.contains(l)).map(l -> this.toMuleLocation((CoverageComponentLocationReport)l)).collect(Collectors.toList()));
        return muleFlow;
    }

    private MuleLocation toMuleLocation(CoverageComponentLocationReport coverageComponentLocation) {
        return new MuleLocation(coverageComponentLocation.getLocation(), coverageComponentLocation.getLineInFile().orElse(-1));
    }

    private boolean isNotIgnoredFlow(LocationPart locationPart) {
        String flowName = locationPart.getPartPath();
        return !this.flowsToIgnore.contains(flowName);
    }

    private boolean isNotIgnoredFile(String fileName) {
        return !this.filesToIgnore.contains(fileName);
    }

    private boolean isNotSuiteFile(String fileName) {
        return !this.suitePaths.contains(fileName);
    }
}

