/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.behavior;

public class ProcessorId {
    private static final String COLON = ":";
    private static final String DEFAULT_NAMESPACE = "mule";
    private String name;
    private String namespace;

    public ProcessorId(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public static String getNamespace(String fullName) {
        String[] split = fullName.split(COLON);
        if (split.length > 1) {
            return split[0];
        }
        return DEFAULT_NAMESPACE;
    }

    public static String getName(String fullName) {
        String[] split = fullName.split(COLON);
        if (split.length > 1) {
            return split[1];
        }
        return split[0];
    }

    public String getFullName() {
        return this.namespace + COLON + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean equals(Object o) {
        if (o instanceof ProcessorId) {
            ProcessorId processorId = (ProcessorId)o;
            return processorId.getName().equals(this.name) && processorId.getNamespace().equals(this.namespace);
        }
        return false;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }
}

