/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.LifecycleManager;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.plexus.ComponentDescriptorBeanModule;
import org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.eclipse.sisu.plexus.PlexusBean;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBindingModule;
import org.eclipse.sisu.plexus.PlexusDateTypeConverter;
import org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.eclipse.sisu.plexus.RealmManager;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.LoadedClass;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.wire.EntryListAdapter;
import org.eclipse.sisu.wire.EntryMapAdapter;
import org.eclipse.sisu.wire.MergedModule;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.slf4j.ILoggerFactory;

public final class DefaultPlexusContainer
implements MutablePlexusContainer {
    private static final String DEFAULT_REALM_NAME = "plexus.core";
    private static final Module[] NO_CUSTOM_MODULES;
    final AtomicInteger plexusRank = new AtomicInteger();
    final Map<ClassRealm, List<ComponentDescriptor<?>>> descriptorMap = new IdentityHashMap();
    final ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();
    final LoggerManagerProvider loggerManagerProvider = new LoggerManagerProvider();
    final MutableBeanLocator qualifiedBeanLocator = new DefaultBeanLocator();
    final Context context;
    final Map<?, ?> variables;
    final ClassRealm containerRealm;
    final RealmManager realmManager;
    final PlexusBeanLocator plexusBeanLocator;
    final BeanManager plexusBeanManager;
    private final String componentVisibility;
    private final boolean isAutoWiringEnabled;
    private final BeanScanning scanning;
    private final Module containerModule = new ContainerModule();
    private final Module defaultsModule = new DefaultsModule();
    private LoggerManager loggerManager = new ConsoleLoggerManager();
    private Logger logger;
    private boolean disposing;

    public DefaultPlexusContainer() throws PlexusContainerException {
        this(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration) throws PlexusContainerException {
        this(configuration, NO_CUSTOM_MODULES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPlexusContainer(ContainerConfiguration configuration, Module ... customModules) throws PlexusContainerException {
        URL plexusXml = this.lookupPlexusXml(configuration);
        this.context = DefaultPlexusContainer.getContextComponent(configuration);
        this.context.put("plexus", this);
        this.variables = new ContextMapAdapter(this.context);
        this.containerRealm = DefaultPlexusContainer.lookupContainerRealm(configuration);
        this.realmManager = new RealmManager(this.qualifiedBeanLocator);
        this.containerRealm.getWorld().addListener((ClassWorldListener)this.realmManager);
        this.componentVisibility = configuration.getComponentVisibility();
        this.isAutoWiringEnabled = configuration.getAutoWiring();
        this.scanning = DefaultPlexusContainer.parseScanningOption(configuration.getClassPathScanning());
        this.plexusBeanLocator = new DefaultPlexusBeanLocator(this.qualifiedBeanLocator, this.realmManager, this.componentVisibility);
        LifecycleManager jsr250Lifecycle = configuration.getJSR250Lifecycle() ? new LifecycleManager() : null;
        this.plexusBeanManager = new PlexusLifecycleManager((Provider<Context>)Providers.of((Object)this.context), (Provider<LoggerManager>)((Object)this.loggerManagerProvider), new SLF4JLoggerFactoryProvider(), jsr250Lifecycle);
        this.setLookupRealm(this.containerRealm);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        URLClassSpace space = new URLClassSpace((ClassLoader)this.containerRealm);
        beanModules.add(new PlexusXmlBeanModule(space, this.variables, plexusXml));
        BeanScanning global = BeanScanning.INDEX == this.scanning ? BeanScanning.GLOBAL_INDEX : this.scanning;
        beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, global, configuration.getStrictClassPathScanning()));
        try {
            this.addPlexusInjector(beanModules, new BootModule(customModules));
        }
        catch (RuntimeException e) {
            try {
                this.dispose();
            }
            finally {
                throw e;
            }
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Object lookup(String role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public Object lookup(String role, String hint) throws ComponentLookupException {
        return this.lookup(null, role, hint);
    }

    @Override
    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.lookup(role, "");
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    @Override
    public <T> T lookup(Class<T> type, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type, hint).iterator().next().getValue();
        }
        catch (RuntimeException e) {
            throw new ComponentLookupException(e, null != type ? type.getName() : role, hint);
        }
    }

    @Override
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return new EntryListAdapter<Object>(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        return new EntryListAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return new EntryMapAdapter<String, Object>(this.locate(role, null, new String[0]));
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        return new EntryMapAdapter(this.locate(null, role, new String[0]));
    }

    @Override
    public boolean hasComponent(String role) {
        return this.hasComponent(role, "");
    }

    @Override
    public boolean hasComponent(String role, String hint) {
        return this.hasComponent((Class)null, role, hint);
    }

    public boolean hasComponent(Class role) {
        return this.hasComponent(role, "");
    }

    public boolean hasComponent(Class role, String hint) {
        return this.hasComponent(role, (String)null, hint);
    }

    public boolean hasComponent(Class type, String role, String hint) {
        return DefaultPlexusContainer.hasPlexusBeans(this.locate(role, type, hint));
    }

    @Override
    public void addComponent(Object component, String role) {
        try {
            this.addComponent(component, component.getClass().getClassLoader().loadClass(role), "default");
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(role, e);
        }
    }

    @Override
    public <T> void addComponent(final T component, final Class<?> role, final String hint) {
        this.qualifiedBeanLocator.add(new InjectorBindings(Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                if (Hints.isDefaultHint(hint)) {
                    binder.bind(role).toInstance(component);
                } else {
                    binder.bind(role).annotatedWith((Annotation)Names.named((String)hint)).toInstance(component);
                }
            }
        }}), new DefaultRankingFunction(this.plexusRank.incrementAndGet())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addComponentDescriptor(ComponentDescriptor<T> descriptor) {
        ClassRealm realm = descriptor.getRealm();
        if (null == realm) {
            realm = this.containerRealm;
            descriptor.setRealm(realm);
        }
        Map<ClassRealm, List<ComponentDescriptor<?>>> map = this.descriptorMap;
        synchronized (map) {
            List<ComponentDescriptor<?>> descriptors = this.descriptorMap.get(realm);
            if (null == descriptors) {
                descriptors = new ArrayList();
                this.descriptorMap.put(realm, descriptors);
            }
            descriptors.add(descriptor);
        }
        if (this.containerRealm == realm) {
            this.discoverComponents(this.containerRealm);
        }
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role, String hint) {
        return this.getComponentDescriptor(null, role, hint);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String hint) {
        PlexusBean<T> bean;
        Iterator<PlexusBean<T>> i = this.locate(role, type, hint).iterator();
        if (i.hasNext() && (bean = i.next()).getImplementationClass() != null) {
            return DefaultPlexusContainer.newComponentDescriptor(role, bean);
        }
        return null;
    }

    public List getComponentDescriptorList(String role) {
        return this.getComponentDescriptorList(null, role);
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        ArrayList<ComponentDescriptor<T>> tempList = new ArrayList<ComponentDescriptor<T>>();
        for (PlexusBean<T> bean : this.locate(role, type, new String[0])) {
            tempList.add(DefaultPlexusContainer.newComponentDescriptor(role, bean));
        }
        return tempList;
    }

    public Map getComponentDescriptorMap(String role) {
        return this.getComponentDescriptorMap(null, role);
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        LinkedHashMap<String, ComponentDescriptor<T>> tempMap = new LinkedHashMap<String, ComponentDescriptor<T>>();
        for (PlexusBean<T> bean : this.locate(role, type, new String[0])) {
            tempMap.put((String)bean.getKey(), DefaultPlexusContainer.newComponentDescriptor(role, bean));
        }
        return tempMap;
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) {
        return this.discoverComponents(realm, NO_CUSTOM_MODULES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm, Module ... customModules) {
        try {
            ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
            Map<ClassRealm, List<ComponentDescriptor<?>>> map = this.descriptorMap;
            synchronized (map) {
                URLClassSpace space = new URLClassSpace((ClassLoader)realm);
                List<ComponentDescriptor<?>> descriptors = this.descriptorMap.remove(realm);
                if (null != descriptors) {
                    beanModules.add(new ComponentDescriptorBeanModule(space, descriptors));
                }
                if (this.containerRealm != realm && !this.realmManager.isManaged(realm)) {
                    beanModules.add(new PlexusXmlBeanModule(space, this.variables));
                    BeanScanning local = BeanScanning.GLOBAL_INDEX == this.scanning ? BeanScanning.INDEX : this.scanning;
                    beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, local));
                }
            }
            if (!beanModules.isEmpty()) {
                this.realmManager.manage(realm, this.addPlexusInjector(beanModules, customModules));
            }
        }
        catch (RuntimeException e) {
            this.getLogger().warn(realm.toString(), e);
        }
        return null;
    }

    public Injector addPlexusInjector(List<? extends PlexusBeanModule> beanModules, Module ... customModules) {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this.containerModule);
        Collections.addAll(modules, customModules);
        modules.add(new PlexusBindingModule(this.plexusBeanManager, beanModules));
        modules.add(this.defaultsModule);
        return Guice.createInjector((Module[])new Module[]{this.isAutoWiringEnabled ? new WireModule(modules) : new MergedModule(modules)});
    }

    @Override
    public ClassWorld getClassWorld() {
        return this.containerRealm.getWorld();
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    @Override
    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        try {
            return this.containerRealm.createChildRealm(id);
        }
        catch (DuplicateRealmException e1) {
            try {
                return this.getClassWorld().getRealm(id);
            }
            catch (NoSuchRealmException e2) {
                return null;
            }
        }
    }

    @Override
    public synchronized LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    @Override
    @Inject(optional=true)
    public synchronized void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = null != loggerManager ? loggerManager : new ConsoleLoggerManager();
        this.logger = null;
    }

    @Override
    public synchronized Logger getLogger() {
        if (null == this.logger) {
            this.logger = this.loggerManager.getLoggerForComponent(PlexusContainer.class.getName(), null);
        }
        return this.logger;
    }

    @Override
    public void release(Object component) {
        this.plexusBeanManager.unmanage(component);
    }

    @Override
    public void releaseAll(Map<String, ?> components) {
        for (Object o : components.values()) {
            this.release(o);
        }
    }

    @Override
    public void releaseAll(List<?> components) {
        for (Object o : components) {
            this.release(o);
        }
    }

    @Override
    public void dispose() {
        this.disposing = true;
        this.plexusBeanManager.unmanage();
        this.containerRealm.setParentRealm(null);
        this.qualifiedBeanLocator.clear();
        this.lookupRealm.remove();
        this.containerRealm.getWorld().removeListener((ClassWorldListener)this.realmManager);
    }

    private static BeanScanning parseScanningOption(String scanning) {
        for (BeanScanning option : BeanScanning.values()) {
            if (!option.name().equalsIgnoreCase(scanning)) continue;
            return option;
        }
        return BeanScanning.OFF;
    }

    private static ClassRealm lookupContainerRealm(ContainerConfiguration configuration) throws PlexusContainerException {
        ClassRealm realm;
        block5: {
            realm = configuration.getRealm();
            if (null == realm) {
                ClassWorld world = configuration.getClassWorld();
                if (null == world) {
                    world = new ClassWorld(DEFAULT_REALM_NAME, Thread.currentThread().getContextClassLoader());
                }
                try {
                    realm = world.getRealm(DEFAULT_REALM_NAME);
                }
                catch (NoSuchRealmException e) {
                    Iterator realmIterator = world.getRealms().iterator();
                    if (!realmIterator.hasNext()) break block5;
                    realm = (ClassRealm)realmIterator.next();
                }
            }
        }
        if (null == realm) {
            throw new PlexusContainerException("Missing container class realm: plexus.core");
        }
        return realm;
    }

    private URL lookupPlexusXml(ContainerConfiguration configuration) {
        String configurationPath;
        URL url = configuration.getContainerConfigurationURL();
        if (null == url && null != (configurationPath = configuration.getContainerConfiguration())) {
            File file;
            int index;
            for (index = 0; index < configurationPath.length() && configurationPath.charAt(index) == '/'; ++index) {
            }
            url = this.getClass().getClassLoader().getResource(configurationPath.substring(index));
            if (null == url && (file = new File(configurationPath)).isFile()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (null == url) {
                this.getLogger().debug("Missing container configuration: " + configurationPath);
            }
        }
        return url;
    }

    private static Context getContextComponent(ContainerConfiguration configuration) {
        Map<Object, Object> contextData = configuration.getContext();
        Context contextComponent = configuration.getContextComponent();
        if (null == contextComponent) {
            return new DefaultContext(contextData);
        }
        if (null != contextData) {
            for (Map.Entry<Object, Object> entry : contextData.entrySet()) {
                contextComponent.put(entry.getKey(), entry.getValue());
            }
        }
        return contextComponent;
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type, String ... hints) {
        if (this.disposing) {
            return Collections.EMPTY_SET;
        }
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (null == role || null != type && type.getName().equals(role)) {
            return this.plexusBeanLocator.locate(TypeLiteral.get(type), canonicalHints);
        }
        HashSet<Class> candidates = new HashSet<Class>();
        for (ClassRealm realm : this.getVisibleRealms()) {
            try {
                Iterable beans;
                Class clazz = realm.loadClass(role);
                if (!candidates.add(clazz) || !DefaultPlexusContainer.hasPlexusBeans(beans = this.plexusBeanLocator.locate(TypeLiteral.get((Class)clazz), canonicalHints))) continue;
                return beans;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
            }
        }
        return Collections.EMPTY_SET;
    }

    private Collection<ClassRealm> getVisibleRealms() {
        Set<String> realmNames;
        ClassRealm threadContextRealm;
        Object[] realms = this.getClassWorld().getRealms().toArray();
        LinkedHashSet<ClassRealm> visibleRealms = new LinkedHashSet<ClassRealm>(realms.length);
        ClassRealm currentLookupRealm = this.getLookupRealm();
        if (null != currentLookupRealm) {
            visibleRealms.add(currentLookupRealm);
        }
        if (null != (threadContextRealm = RealmManager.contextRealm())) {
            visibleRealms.add(threadContextRealm);
        }
        if ("realm".equalsIgnoreCase(this.componentVisibility) && null != (realmNames = this.realmManager.visibleRealmNames(threadContextRealm)) && realmNames.size() > 0) {
            for (int i = realms.length - 1; i >= 0; --i) {
                ClassRealm r = (ClassRealm)realms[i];
                if (!realmNames.contains(r.toString())) continue;
                visibleRealms.add(r);
            }
            return visibleRealms;
        }
        for (int i = realms.length - 1; i >= 0; --i) {
            visibleRealms.add((ClassRealm)realms[i]);
        }
        return visibleRealms;
    }

    private static <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }

    private static <T> ComponentDescriptor<T> newComponentDescriptor(String role, PlexusBean<T> bean) {
        ComponentDescriptor cd = new ComponentDescriptor();
        cd.setRole(role);
        cd.setRoleHint((String)bean.getKey());
        cd.setImplementationClass(bean.getImplementationClass());
        cd.setDescription(bean.getDescription());
        return cd;
    }

    static {
        System.setProperty("guice.disable.misplaced.annotation.check", "true");
        NO_CUSTOM_MODULES = new Module[0];
    }

    final class LoggerManagerProvider
    implements DeferredProvider<LoggerManager> {
        LoggerManagerProvider() {
        }

        public LoggerManager get() {
            return DefaultPlexusContainer.this.getLoggerManager();
        }

        @Override
        public DeferredClass<LoggerManager> getImplementationClass() {
            return new LoadedClass<LoggerManager>(this.get().getClass());
        }
    }

    final class ContainerModule
    implements Module {
        ContainerModule() {
        }

        public void configure(Binder binder) {
            binder.bind(Context.class).toInstance((Object)DefaultPlexusContainer.this.context);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(DefaultPlexusContainer.this.context.getContextData());
            binder.bind(MutableBeanLocator.class).toInstance((Object)DefaultPlexusContainer.this.qualifiedBeanLocator);
            binder.bind(PlexusBeanLocator.class).toInstance((Object)DefaultPlexusContainer.this.plexusBeanLocator);
            binder.bind(BeanManager.class).toInstance((Object)DefaultPlexusContainer.this.plexusBeanManager);
            binder.bind(PlexusContainer.class).to(MutablePlexusContainer.class);
            binder.bind(MutablePlexusContainer.class).to(DefaultPlexusContainer.class);
            binder.bind(DefaultPlexusContainer.class).toProvider(Providers.of((Object)DefaultPlexusContainer.this));
        }
    }

    final class DefaultsModule
    implements Module {
        private final LoggerProvider loggerProvider;
        private final PlexusDateTypeConverter dateConverter;

        DefaultsModule() {
            this.loggerProvider = new LoggerProvider();
            this.dateConverter = new PlexusDateTypeConverter();
        }

        public void configure(Binder binder) {
            binder.bind(LoggerManager.class).toProvider((com.google.inject.Provider)DefaultPlexusContainer.this.loggerManagerProvider);
            binder.bind(Logger.class).toProvider((com.google.inject.Provider)this.loggerProvider);
            Key plexusRankingKey = Key.get(RankingFunction.class, (Annotation)Names.named((String)"plexus"));
            binder.bind(plexusRankingKey).toInstance((Object)new DefaultRankingFunction(DefaultPlexusContainer.this.plexusRank.incrementAndGet()));
            binder.bind(RankingFunction.class).to(plexusRankingKey);
            binder.install((Module)this.dateConverter);
            binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        }
    }

    final class SLF4JLoggerFactoryProvider
    implements Provider<Object> {
        SLF4JLoggerFactoryProvider() {
        }

        @Override
        public Object get() {
            return DefaultPlexusContainer.this.plexusBeanLocator.locate(TypeLiteral.get(ILoggerFactory.class), new String[0]).iterator().next().getValue();
        }
    }

    final class BootModule
    implements Module {
        private final Module[] customBootModules;

        BootModule(Module[] customBootModules) {
            this.customBootModules = customBootModules;
        }

        public void configure(Binder binder) {
            binder.requestInjection((Object)DefaultPlexusContainer.this);
            for (Module m : this.customBootModules) {
                binder.install(m);
            }
        }
    }

    final class LoggerProvider
    implements DeferredProvider<Logger> {
        LoggerProvider() {
        }

        public Logger get() {
            return DefaultPlexusContainer.this.getLogger();
        }

        @Override
        public DeferredClass<Logger> getImplementationClass() {
            return new LoadedClass<Logger>(this.get().getClass());
        }
    }
}

