/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.ContainerInfo;
import org.mule.runtime.module.embedded.api.ContainerInformation;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.internal.dependencies.DefaultDependencyResolver;
import org.mule.runtime.module.embedded.internal.utils.EmbeddedImplementationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedContainer<T>
implements EmbeddedContainer {
    private static final String BOOT_LICENSE_PACKAGE = "com.mulesoft.mule.runtime.module.boot.license";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractEmbeddedContainer.class);
    private final String muleVersion;
    private final ContainerConfiguration containerConfiguration;
    private final List<URL> serverPlugins;
    private final URL containerBaseFolder;
    private final MavenClient mavenClient;
    private final List<URL> services;
    private final ContainerInformation containerInformation;
    private ClassLoader containerModulesClassLoader;
    private boolean started = false;
    private T embeddedController;
    private ClassLoader embeddedControllerBootstrapClassLoader;
    private ExecutorService executorService;

    public AbstractEmbeddedContainer(String muleVersion, ContainerConfiguration containerConfiguration, ClassLoader containerModulesClassLoader, List<URL> services, List<URL> serverPlugins, URL containerBaseFolder, MavenClient mavenClient) {
        this.muleVersion = muleVersion;
        this.containerConfiguration = containerConfiguration;
        this.containerModulesClassLoader = containerModulesClassLoader;
        this.services = services;
        this.serverPlugins = serverPlugins;
        this.containerBaseFolder = containerBaseFolder;
        this.mavenClient = mavenClient;
        this.containerInformation = ContainerInformation.fromContainerClassLoader(containerModulesClassLoader);
    }

    @Override
    public synchronized void start() {
        if (!this.started) {
            try {
                this.embeddedControllerBootstrapClassLoader = EmbeddedImplementationUtils.createEmbeddedImplClassLoader(this.containerModulesClassLoader, new DefaultDependencyResolver(this.mavenClient), this.getMuleContainerVersion());
                ContainerInfo containerInfo = new ContainerInfo(this.muleVersion, this.containerBaseFolder, this.services, this.serverPlugins);
                this.startExecutorService();
                this.embeddedController = this.getEmbeddedController(this.embeddedControllerBootstrapClassLoader, containerInfo);
            }
            catch (Exception e) {
                try {
                    this.doStop();
                }
                catch (Exception eStop) {
                    e.addSuppressed(eStop);
                }
                throw new IllegalStateException("Cannot start embedded container", e);
            }
            this.started = true;
            this.startEmbeddedController(this.embeddedController);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Embedded container already started");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            try {
                this.doStop();
            }
            finally {
                this.started = false;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Embedded container already stopped");
        }
    }

    private void doStop() {
        if (this.embeddedController != null) {
            this.stopEmbeddedController(this.embeddedController);
            this.embeddedController = null;
        }
        try {
            this.mavenClient.close();
        }
        catch (Exception e) {
            LOGGER.error("Error while closing 'mavenClient'", e);
        }
        this.stopExecutorService();
        this.disposeTestingModeInterrupter();
        this.closeClassLoader(this.containerModulesClassLoader);
        this.containerModulesClassLoader = null;
        this.closeClassLoader(this.embeddedControllerBootstrapClassLoader);
        this.embeddedControllerBootstrapClassLoader = null;
    }

    @Override
    public String getMuleContainerVersion() {
        return this.containerInformation.getMuleContainerVersion();
    }

    @Override
    public DeploymentService getDeploymentService() {
        return this.doGetDeploymentService(this.embeddedController);
    }

    @Override
    public File getContainerFolder() {
        return this.containerConfiguration.getContainerFolder();
    }

    @Override
    public boolean isCurrentJvmVersionSupported() {
        return this.containerInformation.isCurrentJvmVersionSupported();
    }

    @Override
    public boolean isCurrentJvmVersionRecommended() {
        return this.containerInformation.isCurrentJvmVersionRecommended();
    }

    protected abstract void startEmbeddedController(T var1);

    protected abstract void stopEmbeddedController(T var1);

    protected abstract DeploymentService doGetDeploymentService(T var1);

    protected abstract T getEmbeddedController(ClassLoader var1, ContainerInfo var2) throws Exception;

    private void startExecutorService() {
        this.executorService = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "Embedded"));
    }

    private void stopExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void disposeTestingModeInterrupter() {
        try {
            Class<?> interrupterClass = this.containerModulesClassLoader.loadClass("com.mulesoft.mule.runtime.module.boot.license.interrupt.TestingModeInterrupter");
            Object interrupter = interrupterClass.getDeclaredMethod("getInterrupter", new Class[0]).invoke(null, new Object[0]);
            interrupterClass.getDeclaredMethod("dispose", new Class[0]).invoke(interrupter, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            LOGGER.debug("Unable to dispose testingMode interrupter: {}", (Object)e.toString());
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error while disposing 'TestingModeInterrupter'", e.getCause());
        }
    }

    private void closeClassLoader(ClassLoader classLoader) {
        block3: {
            if (classLoader instanceof Closeable) {
                try {
                    ((Closeable)((Object)classLoader)).close();
                }
                catch (IOException e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Failure closing container classloader", e);
                }
            }
        }
    }

    protected void executeUsingExecutorService(Callable<Void> callable) {
        Future<?> future = this.executorService.submit(() -> {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.containerModulesClassLoader);
                callable.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        });
        try {
            future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

