/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.V2_Row;
import org.apache.commons.lang3.ArrayUtils;

public class WidthLongestLine
implements V2_Width {
    private int[] minWidths = new int[0];
    private int[] maxWidths = new int[0];

    public WidthLongestLine add(int minWidth, int maxWidth) {
        this.minWidths = ArrayUtils.add((int[])this.minWidths, (int)minWidth);
        this.maxWidths = ArrayUtils.add((int[])this.maxWidths, (int)maxWidth);
        return this;
    }

    @Override
    public int[] getColumnWidths(V2_AsciiTable table) {
        int cols = table.getColumnCount();
        int[] resultWidths = new int[cols];
        System.arraycopy(this.minWidths, 0, resultWidths, 0, this.minWidths.length > cols ? cols : this.minWidths.length);
        for (V2_Row row : table.getTable()) {
            if (!(row instanceof ContentRow)) continue;
            ContentRow crow = (ContentRow)row;
            Object[] cells = crow.getColumns();
            for (int i = 0; i < cells.length; ++i) {
                String[] lines = ArrayTransformations.PROCESS_CONTENT(cells[i]);
                if (lines == null) continue;
                for (String line : lines) {
                    int lineWidth = line.length() + 2 * crow.getPadding()[i];
                    if (lineWidth <= resultWidths[i]) continue;
                    int maxWidth = this.maxWidths.length > i ? this.maxWidths[i] : 0;
                    resultWidths[i] = maxWidth < 1 || lineWidth < maxWidth ? lineWidth : maxWidth;
                }
            }
        }
        return resultWidths;
    }
}

