/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.meta.MuleVersion;

public class MuleApplicationModelLoader {
    public static final MuleVersion MIN_MULE_GA_VERSION = new MuleVersion("4.1.1");
    private MuleApplicationModel muleApplicationModel;
    private String runtimeVersion;
    private String runtimeProduct;
    private Log log;

    public MuleApplicationModelLoader(MuleApplicationModel muleApplicationModel, Log log) {
        this.muleApplicationModel = muleApplicationModel;
        this.log = log;
    }

    public MuleApplicationModelLoader withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public MuleApplicationModelLoader withRuntimeProduct(String runtimeProduct) {
        this.runtimeProduct = runtimeProduct;
        return this;
    }

    public String getRuntimeVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeVersion)) {
            return this.runtimeVersion;
        }
        String runtimeVersion = this.getMinMuleVersion();
        this.log.debug((CharSequence)("Runtime version set to " + runtimeVersion + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeVersion;
    }

    public String getRuntimeProduct() {
        if (StringUtils.isNotBlank((CharSequence)this.runtimeProduct)) {
            return this.runtimeProduct;
        }
        String runtimeProduct = this.muleApplicationModel.getRequiredProduct().name();
        this.log.debug((CharSequence)("Runtime product set to " + runtimeProduct + " obtained from the " + "mule-artifact.json" + " file"));
        return runtimeProduct;
    }

    private String getMinMuleVersion() {
        MuleVersion minMuleVersion = new MuleVersion(this.muleApplicationModel.getMinMuleVersion());
        if (minMuleVersion.atLeast(MIN_MULE_GA_VERSION)) {
            return this.muleApplicationModel.getMinMuleVersion();
        }
        return MIN_MULE_GA_VERSION.toCompleteNumericVersion();
    }
}

