/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import static java.util.Collections.singletonList;

import java.util.List;

import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;

/**
 * Enriches a given {@link Model POM} with a {@link Plugin munit-maven-plugin} declaration
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class MunitMavenPluginEnricher extends PluginPomEnricher {

  public static final String MUNIT_MAVEN_TOOLS_GROUP_ID = "com.mulesoft.munit.tools";
  public static final String MUNIT_MAVEN_PLUGIN_ARTIFACT_ID = "munit-maven-plugin";

  private final String munitMavenPluginVersion;

  public MunitMavenPluginEnricher(String munitMavenPluginVersion) {
    this.munitMavenPluginVersion = munitMavenPluginVersion;
  }

  @Override
  public void generate(Model pomModel) {
    List<PluginExecution> executions = singletonList(createExecution("test", singletonList("test"), "test"));
    Plugin muleMavenPlugin = createPlugin(MUNIT_MAVEN_TOOLS_GROUP_ID, MUNIT_MAVEN_PLUGIN_ARTIFACT_ID, munitMavenPluginVersion,
                                          null, executions, false);
    getBuildNode(pomModel).addPlugin(muleMavenPlugin);
  }

}
