/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

/**
 * Generates the dependency definition for the extension
 *
 * @author Mulesoft Inc.
 * @since 1.1.0
 */
public class CloudHubDependencyGenerator implements DependencyGenerator {

  protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";

  @Override
  public Dependency generateDependency(MavenProject project) {
    Dependency dependency = new Dependency();
    dependency.setGroupId(project.getGroupId());
    dependency.setArtifactId(project.getArtifactId());
    dependency.setVersion(project.getVersion());
    dependency.setClassifier(MULE_PLUGIN_CLASSIFIER);

    return dependency;
  }
}
