/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.munit.extension.maven.api.DiscoverRuntimes;
import org.mule.munit.extension.maven.api.RuntimeConfiguration;
import org.mule.munit.extension.maven.internal.generator.ApplicationMuleArtifactJsonGenerator;
import org.mule.munit.extension.maven.internal.generator.ExtensionApplicationStructureGenerator;
import org.mule.munit.extension.maven.internal.generator.MuleSourcesApplicationGenerator;
import org.mule.munit.extension.maven.internal.generator.maven.ApplicationPomGenerator;
import org.mule.munit.extension.maven.internal.generator.maven.MuleMavenPluginEnricher;
import org.mule.munit.extension.maven.internal.generator.maven.MunitMavenPluginEnricher;
import org.mule.munit.extension.maven.internal.generator.maven.PomEnricher;
import org.mule.munit.extension.maven.internal.locator.ExportedPackagesLocator;
import org.mule.munit.extension.maven.internal.locator.ExportedResourcesLocator;
import org.mule.munit.plugin.maven.AbstractMunitMojo;
import org.mule.munit.plugin.maven.ProductDiscoveryMode;
import org.mule.munit.plugin.maven.RuntimeProducts;
import org.mule.munit.plugin.maven.TargetRuntime;
import org.mule.munit.plugin.maven.locators.RemoteRepositoriesLocator;
import org.mule.munit.plugin.maven.locators.TestConfigFilesLocator;
import org.mule.munit.plugin.maven.util.BaseRunConfigurationFactory;
import org.mule.munit.plugin.maven.util.DefaultResultPrinterFactory;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class ExtensionTestMojo
extends AbstractMunitMojo {
    protected static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal-extension-model.json";
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/mule-artifact/mule-artifact.json")
    protected File muleArtifactJsonFile;
    @Parameter(defaultValue="${project.basedir}/src/test/java")
    protected File testSourcesDirectory;
    @Parameter(defaultValue="${project.testResources}")
    protected List<Resource> testResources;
    @Parameter(property="shared.libraries")
    protected List<SharedLibraryDependency> sharedLibraries;
    @Parameter(property="mule.packager.version", defaultValue="3.1.2")
    protected String packagerVersion;
    @Parameter(property="munit.maven.plugin.version", defaultValue="2.1.2")
    protected String munitMavenPluginVersion;
    @Parameter
    protected RuntimeConfiguration runtimeConfiguration;
    @Parameter(property="attachMuleSources", defaultValue="false")
    protected boolean attachMuleSources;
    @Parameter(property="testApplicationName", defaultValue="${project.artifactId}-test-application")
    protected String testApplicationName;
    protected ApplicationMuleArtifactJsonGenerator muleArtifactJsonGenerator;
    protected ApplicationPomGenerator applicationPomGenerator;
    private ExtensionModel extensionModel;

    protected void init() throws MojoExecutionException {
        this.muleArtifactJsonGenerator = new ApplicationMuleArtifactJsonGenerator(this.getConfigs(), this.getExportedResources(), this.getExportedPackages());
        this.extensionModel = this.getExtensionModel();
        this.applicationPomGenerator = new ApplicationPomGenerator(this.project, this.getPomEnrichers(), this.testApplicationName, this.pluginArtifactId, this.getLog());
        this.runtimeConfiguration = RuntimeConfiguration.builder().from(this.runtimeConfiguration).withOverrides(this.session.getUserProperties()).build();
        super.init();
        this.workingDirectoryGenerator.setDestinationName(this.testApplicationName);
    }

    protected Map<TargetRuntime, RunConfiguration> getRunConfigurations() throws MojoExecutionException {
        TreeMap<TargetRuntime, RunConfiguration> runConfigurations = new TreeMap<TargetRuntime, RunConfiguration>();
        ArrayList<TargetRuntime> effectiveTargetRuntimes = new ArrayList<TargetRuntime>();
        this.addDefaultTargetRuntime(effectiveTargetRuntimes);
        if (!this.shouldRunSingleRuntime()) {
            List<String> additionalRuntimes = this.runtimeConfiguration.getAdditionalRuntimes();
            Optional<DiscoverRuntimes> discoverRuntimes = this.runtimeConfiguration.getDiscoverRuntimes();
            boolean shouldDiscoverRuntimes = discoverRuntimes.map(dr -> !dr.isSkipped()).orElse(false);
            if (CollectionUtils.isNotEmpty(additionalRuntimes)) {
                effectiveTargetRuntimes.addAll(additionalRuntimes.stream().map(TargetRuntime::parse).collect(Collectors.toList()));
            }
            if (shouldDiscoverRuntimes) {
                effectiveTargetRuntimes.addAll(this.discoverRuntimes(this.muleApplicationModelLoader.getRuntimeVersion(), discoverRuntimes.get()));
            }
        }
        for (TargetRuntime targetRuntime : effectiveTargetRuntimes) {
            RunConfiguration runConfiguration = this.createRunConfiguration(targetRuntime);
            runConfigurations.put(targetRuntime, runConfiguration);
            this.generateMuleSources(runConfiguration);
        }
        return runConfigurations;
    }

    protected ResultPrinterFactory getResultPrinterFactory() {
        return new DefaultResultPrinterFactory(this.getLog()).withSurefireReports(Boolean.valueOf(this.enableSurefireReports), this.surefireReportsFolder, this.effectiveSystemProperties).withTestOutputReports(Boolean.valueOf(this.redirectTestOutputToFile), this.testOutputDirectory);
    }

    protected ExtensionApplicationStructureGenerator getApplicationStructureGenerator() throws MojoExecutionException {
        try {
            return new ExtensionApplicationStructureGenerator(this.buildDirectory.toPath(), this.project.getGroupId(), this.testApplicationName, this.applicationPomGenerator, this.generatePomProperties(), this.generateMuleArtifactJson());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create application structure", (Exception)e);
        }
    }

    protected File getMuleApplicationJsonPath() {
        return this.muleArtifactJsonFile;
    }

    protected RemoteRepositoriesLocator createRemoteRepositoriesLocator() {
        RemoteRepositoriesLocator remoteRepositoriesLocator = super.createRemoteRepositoriesLocator();
        return this.runtimeConfiguration.getDiscoverRuntimes().map(discoverRuntimes -> remoteRepositoriesLocator.setWhiteListRepositories(discoverRuntimes.getRuntimeRepositories())).orElse(remoteRepositoriesLocator);
    }

    protected byte[] generateMuleArtifactJson() throws IOException {
        String muleArtifactJson = FileUtils.readFileToString((File)this.muleArtifactJsonFile, (Charset)Charset.defaultCharset());
        MuleApplicationModel originalMuleApplicationModel = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(muleArtifactJson);
        MuleApplicationModel appMuleApplicationModel = this.muleArtifactJsonGenerator.generate(originalMuleApplicationModel);
        return new MuleApplicationModelJsonSerializer().serialize((AbstractMuleArtifactModel)appMuleApplicationModel).getBytes(Charset.defaultCharset());
    }

    protected byte[] generatePomProperties() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("groupId", this.project.getGroupId());
        properties.setProperty("artifactId", this.testApplicationName);
        properties.setProperty("version", this.project.getVersion());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        properties.store(output, "Generated by " + this.pluginArtifactId);
        return output.toByteArray();
    }

    private Set<TargetRuntime> discoverRuntimes(String runtimeVersion, DiscoverRuntimes discoverRuntimes) throws MojoExecutionException {
        ProductDiscoveryMode product = discoverRuntimes.getProduct().orElseThrow(() -> new MojoExecutionException(String.format("Invalid Runtime Configuration: the auto discovery of runtimes was enabled but no product kind was specified, neither in the plugin nor using the command line argument '%s'. One of the following products has to be selected: %s", "discoverRuntimes.product", Arrays.asList(ProductDiscoveryMode.values()))));
        if (this.muleApplicationModelLoader.getRuntimeProduct().equals(RuntimeProducts.EE.value()) && product.supportsCe()) {
            throw new MojoExecutionException(String.format("Product is EE only but was configured to discover %s runtimes.", product.name()));
        }
        this.runtimeVersionsLocator.includingSnapshots(discoverRuntimes.isIncludeSnapshots()).withMinMuleVersion(discoverRuntimes.getMinMuleVersion().orElse(runtimeVersion)).withProductDiscoveryMode(product);
        return this.runtimeVersionsLocator.locate();
    }

    private void addDefaultTargetRuntime(List<TargetRuntime> effectiveTargetRuntimes) {
        effectiveTargetRuntimes.add(new TargetRuntime(this.muleApplicationModelLoader.getRuntimeVersion(), this.muleApplicationModelLoader.getRuntimeProduct()));
    }

    private RunConfiguration createRunConfiguration(TargetRuntime targetRuntime) throws MojoExecutionException {
        return new BaseRunConfigurationFactory(this.getLog(), this.testApplicationName, this.munitTest, this.munitTags, Boolean.valueOf(this.skipAfterFailure), targetRuntime, this.workingDirectoryGenerator, this.munitTestsDirectory, this.project, this.session).create();
    }

    private Set<String> getConfigs() {
        return new TestConfigFilesLocator().locateFiles(this.munitTestsDirectory).stream().map(suiteFile -> this.munitTestsDirectory.toURI().relativize(suiteFile.toURI())).map(URI::getPath).collect(Collectors.toSet());
    }

    private Set<String> getExportedResources() {
        return this.testResources.stream().map(resource -> new ExportedResourcesLocator(new File(resource.getDirectory())).locate()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> getExportedPackages() {
        return new ExportedPackagesLocator(this.testSourcesDirectory).locate();
    }

    private List<PomEnricher> getPomEnrichers() throws MojoExecutionException {
        ArrayList<PomEnricher> pomEnrichers = new ArrayList<PomEnricher>();
        pomEnrichers.add(new MuleMavenPluginEnricher(this.getExtensionModel(), this.project, this.getSharedLibraries(), this.packagerVersion));
        pomEnrichers.add(new MunitMavenPluginEnricher(this.munitMavenPluginVersion));
        return pomEnrichers;
    }

    private List<SharedLibraryDependency> getSharedLibraries() {
        return this.sharedLibraries == null ? Collections.emptyList() : this.sharedLibraries;
    }

    private void generateMuleSources(RunConfiguration runConfiguration) throws MojoExecutionException {
        if (this.attachMuleSources) {
            new MuleSourcesApplicationGenerator(this.testApplicationName, this.project, this.getApplicationStructureGenerator()).generate(this.buildDirectory.toPath(), runConfiguration);
        }
    }

    private boolean shouldRunSingleRuntime() {
        return this.runtimeVersion != null || this.runtimeProduct != null;
    }

    protected ExtensionModel getExtensionModel() throws MojoExecutionException {
        if (this.extensionModel == null) {
            File generatedExtensionModelFile = new File(this.buildDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
            try {
                String serializedExModel = new String(Files.readAllBytes(generatedExtensionModelFile.toPath()), "UTF-8");
                this.extensionModel = new ExtensionModelJsonSerializer(true).deserialize(serializedExModel);
            }
            catch (Exception e) {
                throw new MojoExecutionException(String.format("Cannot obtain/read the file [%s] to deserialize the ExtensionModel", generatedExtensionModelFile.getAbsolutePath()), e);
            }
        }
        return this.extensionModel;
    }
}

