/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.util.Objects;
import java.util.function.Supplier;

public class Preconditions {
    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new IllegalArgumentException(message.get());
        }
    }

    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new IllegalStateException(message.get());
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (Objects.isNull(reference)) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference) {
        return Preconditions.checkNotNull(reference, "Value cannot be null");
    }

    private Preconditions() {
    }
}

