/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.api.model.stereotype;

import static org.mule.munit.common.api.model.stereotype.MUnitStereotypeDefinition.MUNIT_NAMESPACE;
import static org.mule.munit.common.api.model.stereotype.MUnitToolsStereotypeDefinition.MUNIT_TOOLS_NAMESPACE;
import static org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder.newStereotype;
import static org.mule.runtime.extension.api.stereotype.MuleStereotypes.PROCESSOR;

import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

/**
 * Stereotypes definitions for MUnit components
 * 
 * @author Mulesoft Inc.
 * @since 2.4
 */
public class MUnitStereotypes {

  public static final StereotypeDefinition MUNIT_TEST_PROCESSOR_DEFINITION = new MUnitTestProcessorStereotype();
  public static final StereotypeDefinition MUNIT_ASSERTION_DEFINITION = new MUnitAssertionStereotype();
  public static final StereotypeDefinition MUNIT_MOCK_DEFINITION = new MUnitMockStereotype();
  public static final StereotypeDefinition MUNIT_AFTER_TEST_DEFINITION = new MUnitAfterTestStereotype();
  public static final StereotypeDefinition MUNIT_BEFORE_TEST_DEFINITION = new MUnitBeforeTestStereotype();
  public static final StereotypeDefinition MUNIT_AFTER_SUITE_DEFINITION = new MUnitAfterSuiteStereotype();
  public static final StereotypeDefinition MUNIT_BEFORE_SUITE_DEFINITION = new MUnitBeforeSuiteStereotype();
  public static final StereotypeModel TEST_PROCESSOR =
      newStereotype(MUNIT_TEST_PROCESSOR_DEFINITION.getName(), MUNIT_NAMESPACE).withParent(PROCESSOR).build();

  public static final StereotypeModel AFTER_TEST =
      newStereotype(MUNIT_AFTER_TEST_DEFINITION.getName(), MUNIT_NAMESPACE).build();
  public static final StereotypeModel BEFORE_TEST =
      newStereotype(MUNIT_BEFORE_TEST_DEFINITION.getName(), MUNIT_NAMESPACE).build();
  public static final StereotypeModel AFTER_SUITE =
      newStereotype(MUNIT_AFTER_SUITE_DEFINITION.getName(), MUNIT_NAMESPACE).build();
  public static final StereotypeModel BEFORE_SUITE =
      newStereotype(MUNIT_BEFORE_SUITE_DEFINITION.getName(), MUNIT_NAMESPACE).build();
  public static final StereotypeModel BEHAVIOR_SCOPE =
      newStereotype("BEHAVIOR", MUNIT_NAMESPACE).build();
  public static final StereotypeModel EXECUTION_SCOPE =
      newStereotype("EXECUTION", MUNIT_NAMESPACE).build();
  public static final StereotypeModel VALIDATION_SCOPE =
      newStereotype("VALIDATION", MUNIT_NAMESPACE).build();
  public static final StereotypeModel ASSERTION =
      newStereotype(MUNIT_ASSERTION_DEFINITION.getName(), MUNIT_TOOLS_NAMESPACE).withParent(TEST_PROCESSOR).build();

  public static final StereotypeModel MOCK =
      newStereotype(MUNIT_MOCK_DEFINITION.getName(), MUNIT_TOOLS_NAMESPACE).withParent(TEST_PROCESSOR).build();

}
