/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.api.model;

import java.util.Objects;
import org.mule.munit.common.util.MunitExpressionWrapper;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Alias(value="with-attribute")
public class Attribute {
    @Parameter
    @Placement(order=0)
    private String attributeName;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Placement(order=1)
    private Object whereValue;

    public static Attribute create(String name, String whereValue) {
        Attribute attribute = new Attribute();
        attribute.setAttributeName(name);
        attribute.setWhereValue(whereValue);
        return attribute;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Object getWhereValue() {
        return this.whereValue;
    }

    public void setWhereValue(Object whereValue) {
        this.whereValue = whereValue;
    }

    public Attribute getEvaluatedAttribute(Event event, MunitExpressionWrapper expressionWrapper) {
        Attribute evaluatedAttribute = new Attribute();
        evaluatedAttribute.setAttributeName(expressionWrapper.evaluateAsStringIfExpression(event, (Object)this.getAttributeName()));
        evaluatedAttribute.setWhereValue(expressionWrapper.evaluateIfExpression(event, this.getWhereValue()).getValue());
        return evaluatedAttribute;
    }

    public String toString() {
        return "Attribute{attributeName='" + this.attributeName + '\'' + ", whereValue=" + this.whereValue + '}';
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Attribute that = (Attribute)object;
        return Objects.equals(this.getAttributeName(), that.getAttributeName()) && Objects.equals(this.getWhereValue(), that.getWhereValue());
    }

    public int hashCode() {
        return Objects.hash(this.getAttributeName(), this.getWhereValue());
    }
}

