/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.mule.munit.assertion.api.expression.MatcherResult;
import org.mule.munit.assertion.internal.matchers.ValueMatcher;
import org.mule.runtime.api.metadata.TypedValue;

public class AssertModule {
    public void assertThat(String message, TypedValue expression, Matcher is) {
        MatcherAssert.assertThat((String)AssertModule.wrapMessage(message), (Object)expression, (Matcher)is);
    }

    protected void assertThat(String message, Object value, Matcher is) {
        TypedValue typedValue = new TypedValue(value, null);
        ValueMatcher typedValueMatcher = new ValueMatcher(is);
        this.assertThat(message, typedValue, (Matcher)typedValueMatcher);
    }

    public void assertMatcherResult(MatcherResult matcherResult, String message) {
        if (!matcherResult.isMatches()) {
            throw new AssertionError((Object)AssertModule.generateMatcherResultMessage(matcherResult, message));
        }
    }

    private static String wrapMessage(String message) {
        return message == null ? "" : message;
    }

    private static String generateMatcherResultMessage(MatcherResult matcherResult, String message) {
        MatcherResult.Description description = matcherResult.getDescription();
        List<String> reasons = matcherResult.getReasons();
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(message);
        if (description.getMessage() != null) {
            messageBuilder.append(System.lineSeparator()).append(description.getMessage());
        } else {
            messageBuilder.append(System.lineSeparator()).append("Expected: ").append(description.getExpected());
            messageBuilder.append(System.lineSeparator()).append("Actual: ").append(description.getActual());
        }
        if (Objects.nonNull(reasons) && !reasons.isEmpty()) {
            messageBuilder.append(System.lineSeparator()).append("Reasons: ");
            messageBuilder.append(reasons.stream().collect(Collectors.joining(", ")));
        }
        return messageBuilder.toString();
    }
}

