/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.assertion.internal;

import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.mule.munit.assertion.api.matchers.Matcher;
import org.mule.munit.assertion.internal.matchers.CallbackMatcher;
import org.mule.munit.assertion.internal.matchers.EncodingMatcher;
import org.mule.munit.assertion.internal.matchers.IterableMatcher;
import org.mule.munit.assertion.internal.matchers.MediaTypeMatcher;
import org.mule.munit.assertion.internal.matchers.TypedValueMatcher;
import org.mule.munit.assertion.internal.matchers.ValueMatcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class HamcrestFactory {
    public static org.hamcrest.Matcher<TypedValue> create(Matcher munitMatcher) {
        switch (munitMatcher.getType()) {
            case "equalTo": 
            case "nullValue": 
            case "notNullValue": 
            case "matches": 
            case "containsString": 
            case "startsWith": 
            case "endsWith": 
            case "isEmptyString": 
            case "isEmptyOrNullString": 
            case "equalToIgnoringCase": 
            case "equalToIgnoringWhiteSpace": 
            case "stringContainsInOrder": 
            case "greaterThan": 
            case "greaterThanOrEqualTo": 
            case "lessThan": 
            case "lessThanOrEqualTo": {
                return new CallbackMatcher((Function)munitMatcher.getExpected()[0]);
            }
            case "not": {
                return CoreMatchers.not(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]));
            }
            case "both": {
                return CoreMatchers.allOf((org.hamcrest.Matcher[])new org.hamcrest.Matcher[]{HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]), HamcrestFactory.create((Matcher)munitMatcher.getExpected()[1])});
            }
            case "either": {
                return CoreMatchers.anyOf((org.hamcrest.Matcher[])new org.hamcrest.Matcher[]{HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]), HamcrestFactory.create((Matcher)munitMatcher.getExpected()[1])});
            }
            case "withEncoding": {
                String charset = (String)munitMatcher.getExpected()[0];
                return new EncodingMatcher(CoreMatchers.equalTo((Object)(charset == null ? null : Charset.forName(charset))));
            }
            case "withMediaType": {
                String mediaType = (String)munitMatcher.getExpected()[0];
                return new MediaTypeMatcher(mediaType == null ? null : MediaType.parse((String)mediaType));
            }
            case "allOf": {
                return CoreMatchers.allOf((Iterable)Stream.of(munitMatcher.getExpected()).map(matcher -> (Matcher)matcher).map(HamcrestFactory::create).collect(Collectors.toList()));
            }
            case "anyOf": {
                return CoreMatchers.anyOf((Iterable)Stream.of(munitMatcher.getExpected()).map(matcher -> (Matcher)matcher).map(HamcrestFactory::create).collect(Collectors.toList()));
            }
            case "closeTo": {
                return new ValueMatcher(Matchers.closeTo((double)((Number)munitMatcher.getExpected()[0]).doubleValue(), (double)((Number)munitMatcher.getExpected()[1]).doubleValue()));
            }
            case "everyItem": {
                return new IterableMatcher((org.hamcrest.Matcher<? extends Iterable<?>>)CoreMatchers.everyItem(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "hasItem": {
                return new IterableMatcher((org.hamcrest.Matcher<? extends Iterable<?>>)CoreMatchers.hasItem(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "hasSize": {
                return new IterableMatcher((org.hamcrest.Matcher<? extends Iterable<?>>)Matchers.hasSize(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "isEmpty": {
                return new IterableMatcher((org.hamcrest.Matcher<? extends Iterable<?>>)Matchers.empty());
            }
            case "hasKey": {
                return new ValueMatcher(Matchers.hasKey(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
            case "hasValue": {
                return new ValueMatcher(Matchers.hasValue(HamcrestFactory.toPlainMatcher(HamcrestFactory.create((Matcher)munitMatcher.getExpected()[0]))));
            }
        }
        throw new IllegalArgumentException("Unknown Matcher: " + munitMatcher.getType());
    }

    private static org.hamcrest.Matcher<Object> toPlainMatcher(org.hamcrest.Matcher<TypedValue> typedValueMatcher) {
        if (typedValueMatcher instanceof TypedValueMatcher) {
            return ((TypedValueMatcher)typedValueMatcher).toPlainValueMatcher();
        }
        throw new IllegalArgumentException("The provided matcher should only be applicable for the value of TypedValue");
    }
}

