/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal.impl;

import com.mulesoft.mq.restclient.client.mq.domain.AnypointMQMessage;
import com.mulesoft.mq.restclient.internal.BufferedQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBufferedQueue
implements BufferedQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleBufferedQueue.class);
    private final BlockingQueue<AnypointMQMessage> bufferQueue = new LinkedBlockingQueue<AnypointMQMessage>();

    @Override
    public void add(AnypointMQMessage message) {
        LOGGER.debug("Adding message '{}'", (Object)message.getMessageId());
        this.bufferQueue.add(message);
    }

    @Override
    public AnypointMQMessage take() {
        LOGGER.debug("Taking message from buffer");
        return (AnypointMQMessage)this.bufferQueue.poll();
    }

    @Override
    public AnypointMQMessage poll(long timeout, TimeUnit unit) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Polling message from buffer with timeout of {} MILLIS", (Object)unit.toMillis(timeout));
        }
        try {
            return this.bufferQueue.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        this.bufferQueue.clear();
    }

    @Override
    public int size() {
        return this.bufferQueue.size();
    }
}

