/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.mulesoft.mule.runtime.module.batch.BatchEvent;
import com.mulesoft.mule.runtime.module.batch.BatchEventWithSecurity;
import com.mulesoft.mule.runtime.module.batch.BatchEventWithSpan;
import com.mulesoft.mule.runtime.module.batch.internal.kryo.LegacyBatchEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BatchEventSerializer
extends Serializer<BatchEvent> {
    private static final ThreadLocal<Boolean> useLegacyBatchEventSerializer = new ThreadLocal();
    private final Map<String, FieldSerializer> fieldSerializerMap = new HashMap<String, FieldSerializer>();
    private FieldSerializer<LegacyBatchEvent> legacyBatchEventSerializer;

    public BatchEventSerializer(Kryo kryo) {
        this.init(kryo);
    }

    public static void setLegacyBatchEventSerializer() {
        useLegacyBatchEventSerializer.set(true);
    }

    public static void unsetLegacyBatchEventSerializer() {
        useLegacyBatchEventSerializer.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Kryo kryo) {
        this.legacyBatchEventSerializer = new FieldSerializer(kryo, LegacyBatchEvent.class);
        if (this.fieldSerializerMap.isEmpty()) {
            BatchEventSerializer batchEventSerializer = this;
            synchronized (batchEventSerializer) {
                this.fieldSerializerMap.put(BatchEvent.class.getName(), new FieldSerializer(kryo, BatchEvent.class));
                this.fieldSerializerMap.put(BatchEventWithSecurity.class.getName(), new FieldSerializer(kryo, BatchEventWithSecurity.class));
                this.fieldSerializerMap.put(BatchEventWithSpan.class.getName(), new FieldSerializer(kryo, BatchEventWithSpan.class));
            }
        }
    }

    public void write(Kryo kryo, Output output, BatchEvent event) {
        this.fieldSerializerMap.get(event.getClass().getName()).write(kryo, output, (Object)event);
    }

    public BatchEventWithSpan read(Kryo kryo, Input input, Class<BatchEvent> type) {
        if (Boolean.TRUE.equals(useLegacyBatchEventSerializer.get())) {
            LegacyBatchEvent legacyBatchEvent = (LegacyBatchEvent)this.legacyBatchEventSerializer.read(kryo, input, LegacyBatchEvent.class);
            return new BatchEventWithSpan(legacyBatchEvent.getCorrelationId(), legacyBatchEvent.getVariables(), legacyBatchEvent.getComponentLocation(), Optional.empty(), null);
        }
        if (type.getTypeName().equals(BatchEventWithSpan.class.getName())) {
            return (BatchEventWithSpan)this.deserializeBatchEvent(kryo, input, BatchEventWithSpan.class);
        }
        if (type.getTypeName().equals(BatchEventWithSecurity.class.getName())) {
            BatchEventWithSecurity batchEvent = (BatchEventWithSecurity)this.deserializeBatchEvent(kryo, input, BatchEventWithSecurity.class);
            return new BatchEventWithSpan(batchEvent.getCorrelationId(), batchEvent.getVariables(), batchEvent.getComponentLocation(), batchEvent.getLoggingVariables(), batchEvent.getSecurityContext().orElse(null));
        }
        BatchEvent batchEvent = this.deserializeBatchEvent(kryo, input, BatchEvent.class);
        return new BatchEventWithSpan(batchEvent.getCorrelationId(), batchEvent.getVariables(), batchEvent.getComponentLocation(), batchEvent.getLoggingVariables(), null);
    }

    private BatchEvent deserializeBatchEvent(Kryo kryo, Input input, Class batchEventClass) {
        FieldSerializer fieldSerializer = this.fieldSerializerMap.get(batchEventClass.getName());
        return (BatchEvent)fieldSerializer.read(kryo, input, batchEventClass);
    }
}

