/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.resolution;

import com.mulesoft.mule.framework.api.extension.config.ConfigurationHandler;
import com.mulesoft.mule.framework.api.tooling.type.override.TypeOverrideKey;
import com.mulesoft.mule.framework.api.tooling.type.resolution.MetadataStorage;
import com.mulesoft.mule.framework.api.tooling.type.resolution.MetadataStorageId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.tooling.type.override.enrichment.model.DefaultTypeOverrideKey;
import org.mule.framework.internal.tooling.type.override.enrichment.model.TypeOverridesRepository;
import org.mule.framework.internal.tooling.type.resolution.DefaultMetadataStorageId;
import org.mule.framework.internal.tooling.type.resolution.ExpressionNotSupportedException;
import org.mule.framework.internal.tooling.type.resolution.InternalTypeResolutionSession;
import org.mule.framework.internal.tooling.type.resolution.MetadataKeyDeclarationResolver;
import org.mule.framework.internal.tooling.type.resolution.MetadataKeyResult;
import org.mule.framework.internal.tooling.type.resolution.MetadataStorageToCacheAdapter;
import org.mule.framework.internal.tooling.type.resolution.OfflineConnectionManager;
import org.mule.framework.internal.tooling.type.resolution.OfflineModeConnectionException;
import org.mule.framework.internal.tooling.type.resolution.SerializableMetadataKeyResult;
import org.mule.framework.internal.tooling.type.resolution.SerilizableComponentTypeResult;
import org.mule.framework.internal.tooling.type.resolution.TypeResolutionPropagationContext;
import org.mule.framework.internal.util.CloseChecker;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.metadata.ScopeOutputMetadataContext;
import org.mule.runtime.api.metadata.descriptor.BaseInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.RouterInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ScopeInputMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.module.extension.api.runtime.config.ExtensionDesignTimeResolversFactory;
import org.mule.runtime.module.extension.api.tooling.metadata.MetadataMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DietTypeResolutionSession
implements InternalTypeResolutionSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(DietTypeResolutionSession.class);
    private final CloseChecker closer;
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;
    private final InternalMuleFramework mule;
    private final TypeOverridesRepository typeOverridesRepository;
    private final MetadataMediator mediator;
    private final ClassTypeLoader typeLoader;
    private final ClassLoader extensionClassLoader;
    private final MetadataStorage metadataStorage;
    private final ComponentParameterizationMetadataCacheIdGenerator idGenerator;
    private final ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory;
    private final boolean offlineMode = Boolean.getBoolean("mule.framework.typeResolution.offline");

    public DietTypeResolutionSession(InternalMuleFramework mule, ExtensionModel extensionModel, ComponentModel componentModel, ExtensionDesignTimeResolversFactory extensionDesignTimeResolversFactory, TypeOverridesRepository typeOverridesRepository) {
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.mule = mule;
        this.typeOverridesRepository = typeOverridesRepository;
        this.mediator = mule.getExtensionDesignTimeResolversFactory().createMetadataMediator(componentModel);
        this.extensionClassLoader = MuleFrameworkUtils.getClassLoader(extensionModel);
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.extensionClassLoader);
        this.metadataStorage = mule.getMetadataStorage();
        this.idGenerator = mule.getIdGenerator();
        this.extensionDesignTimeResolversFactory = extensionDesignTimeResolversFactory;
        this.closer = new CloseChecker("DietTypeResolutionSession", mule);
    }

    private MetadataResult<MetadataKeysContainer> doGetMetadataKeys(ComponentParameterization<? extends ComponentModel> parameterization, Optional<ConfigurationHandler> configurationHandler) {
        MetadataContext context = this.createMetadataContext(configurationHandler);
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, () -> this.mediator.getMetadataKeys(context, this.extensionDesignTimeResolversFactory.createParameterValueResolver(parameterization, parameterization.getModel(), () -> MuleFrameworkUtils.resolveConfiguration(configurationHandler))));
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentParameterization<? extends ComponentModel> parameterization, Optional<ConfigurationHandler> configurationHandler) throws MetadataResolvingException, ConnectionException {
        return (MetadataResult)this.closer.withLifecycleCheck(() -> {
            this.validateParameterization(parameterization);
            Optional configId = configurationHandler.flatMap(ch -> this.mule.getConfigIdGenerator().getConfigMetadataCacheId(ch.getName(), false));
            Optional<MetadataStorageId> storageId = this.idGenerator.getIdForMetadataKeys((Object)parameterization).map(cacheId -> DefaultMetadataStorageId.createFromCacheIdValueAndConfigId(configId, cacheId));
            if (storageId.isPresent()) {
                SerializableMetadataKeyResult serializableResult = (SerializableMetadataKeyResult)this.metadataStorage.computeIfAbsent(storageId.get(), id -> new SerializableMetadataKeyResult(this.doGetMetadataKeys(parameterization, configurationHandler)));
                return serializableResult.toKeysMetadataResult();
            }
            return this.doGetMetadataKeys(parameterization, configurationHandler);
        });
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentParameterization<? extends ComponentModel> parameterization, String configName) throws MetadataResolvingException, ConnectionException {
        return (MetadataResult)this.closer.withLifecycleCheck(() -> {
            ConfigurationHandler configurationHandler = this.mule.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
            return this.getMetadataKeys(parameterization, Optional.of(configurationHandler));
        });
    }

    @Override
    public <T extends ComponentModel> MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentTypes(ComponentParameterization<T> parameterization, Optional<ConfigurationHandler> configurationHandler, TypeResolutionPropagationContext typeResolutionPropagationContext, TypeOverrideKey typeOverrideKey) throws MetadataResolvingException, ConnectionException {
        return (MetadataResult)this.closer.withLifecycleCheck(() -> {
            this.validateParameterization(parameterization);
            Optional configId = configurationHandler.flatMap(ch -> this.mule.getConfigIdGenerator().getConfigMetadataCacheId(ch.getName(), false));
            Optional<MetadataStorageId> storageId = this.idGenerator.getIdForComponentMetadata((Object)parameterization).map(cacheId -> DefaultMetadataStorageId.createFromCacheIdValueAndConfigId(configId, cacheId));
            if (storageId.isPresent()) {
                SerilizableComponentTypeResult serializableResult = (SerilizableComponentTypeResult)this.metadataStorage.computeIfAbsent(storageId.get(), id -> new SerilizableComponentTypeResult(this.doResolveComponentTypes(parameterization, configurationHandler, typeResolutionPropagationContext, typeOverrideKey)));
                return serializableResult.toKeysMetadataResult();
            }
            return this.doResolveComponentTypes(parameterization, configurationHandler, typeResolutionPropagationContext, typeOverrideKey);
        });
    }

    @Override
    public <T extends ComponentModel> MetadataResult<ComponentMetadataTypesDescriptor> resolveComponentTypes(ComponentParameterization<T> parameterization, String configName, TypeResolutionPropagationContext typeResolutionPropagationContext, TypeOverrideKey typeOverrideKey) throws MetadataResolvingException, ConnectionException {
        return (MetadataResult)this.closer.withLifecycleCheck(() -> {
            ConfigurationHandler configurationHandler = this.mule.getConfigurationHandler(configName).orElseThrow(() -> new IllegalArgumentException(String.format("No config with name '%s' is registered on this instance", configName)));
            return this.resolveComponentTypes(parameterization, Optional.of(configurationHandler), typeResolutionPropagationContext, typeOverrideKey);
        });
    }

    public TypeOverrideKey createTypeOverrideKey(ComponentAst componentAst) {
        return new DefaultTypeOverrideKey(componentAst);
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataTypesDescriptor> doResolveComponentTypes(ComponentParameterization<T> parameterization, Optional<ConfigurationHandler> configurationHandler, TypeResolutionPropagationContext typeResolutionPropagationContext, TypeOverrideKey typeOverrideKey) {
        MetadataKeyResult metadataKeyResult;
        try {
            metadataKeyResult = new MetadataKeyDeclarationResolver(this.componentModel, parameterization.getParameters().entrySet().stream().collect(Collectors.toMap(e -> new Pair((Object)((ParameterGroupModel)((Pair)e.getKey()).getFirst()).getName(), (Object)((ParameterModel)((Pair)e.getKey()).getSecond()).getName()), e -> e.getValue())), this.mule.getExpressionManager()).resolveKeyResult();
        }
        catch (ExpressionNotSupportedException e2) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e2).withFailureCode(FailureCode.INVALID_METADATA_KEY).onKeys()});
        }
        if (!metadataKeyResult.isComplete()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(metadataKeyResult.getPartialReason()).withFailureCode(FailureCode.INVALID_METADATA_KEY).onComponent()});
        }
        MetadataKey metadataKey = metadataKeyResult.getMetadataKey();
        LOGGER.debug("Invoking connector's component metadata resolver for component: {} with key: {}", (Object)this.componentModel.getName(), (Object)metadataKey);
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleFrameworkUtils.getClassLoader(this.extensionModel), () -> {
            try {
                MetadataContext inputMetadataContext = this.createMetadataContext(configurationHandler, Optional.empty(), Optional.empty());
                Object inputMetadata = ExtensionModelUtils.isScope((ComponentModel)this.componentModel) ? this.resolveScopeInput(typeResolutionPropagationContext, inputMetadataContext, metadataKey) : (ExtensionModelUtils.isRouter((ComponentModel)this.componentModel) ? this.resolveRouterInput(typeResolutionPropagationContext, inputMetadataContext, metadataKey) : this.mediator.getInputMetadata(inputMetadataContext, metadataKey));
                MetadataContext outputMetadataContext = this.createMetadataContext(configurationHandler, typeResolutionPropagationContext.getScopeOutputMetadataContext(), typeResolutionPropagationContext.getRouterOutputMetadataContext());
                MetadataResult outputMetadata = this.mediator.getOutputMetadata(outputMetadataContext, metadataKey);
                MetadataResult<ComponentMetadataTypesDescriptor> collectMetadataResult = this.collectMetadata((MetadataResult<? extends BaseInputMetadataDescriptor>)inputMetadata, (MetadataResult<OutputMetadataDescriptor>)outputMetadata, this.typeOverridesRepository.getComponentTypeOverride(typeOverrideKey));
                if (this.offlineMode && !collectMetadataResult.isSuccess() && collectMetadataResult.getFailures().stream().allMatch(mf -> ("Failed to establish connection: " + OfflineModeConnectionException.class.getSimpleName() + ": " + "Offline Type Resolution mode").equals(mf.getMessage()))) {
                    return this.createOfflineMetadataResult((HasOutputModel)this.componentModel);
                }
                return collectMetadataResult;
            }
            catch (Exception e) {
                if (this.offlineMode && e instanceof OfflineModeConnectionException) {
                    return this.createOfflineMetadataResult((HasOutputModel)this.componentModel);
                }
                return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
            }
        });
    }

    private MetadataResult<ComponentMetadataTypesDescriptor> createOfflineMetadataResult(HasOutputModel compModel) {
        return MetadataResult.success((Object)ComponentMetadataTypesDescriptor.builder().keepNonDynamicMetadata(true).withOutputMetadataDescriptor(OutputMetadataDescriptor.builder().withReturnType(compModel.getOutput().getType()).withAttributesType(compModel.getOutputAttributes().getType()).build()).build());
    }

    private MetadataResult<ScopeInputMetadataDescriptor> resolveScopeInput(TypeResolutionPropagationContext typeResolutionPropagationContext, MetadataContext metadataContext, MetadataKey metadataKey) {
        Optional<ScopeOutputMetadataContext> scopeOutputMetadataContext = typeResolutionPropagationContext.getScopeOutputMetadataContext();
        if (!scopeOutputMetadataContext.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("Cannot resolve scope input metadata without a scope output metadata context").onComponent()});
        }
        MetadataResult scopeInputMetadata = this.mediator.getScopeInputMetadata(metadataContext, metadataKey, scopeOutputMetadataContext.get().getScopeInputMessageType(), typeResolutionPropagationContext.getPropagatedParameterTypeResolver());
        if (scopeInputMetadata.isSuccess()) {
            typeResolutionPropagationContext.setScopeInnerChainInput((ScopeInputMetadataDescriptor)scopeInputMetadata.get());
        }
        return scopeInputMetadata;
    }

    private MetadataResult<RouterInputMetadataDescriptor> resolveRouterInput(TypeResolutionPropagationContext typeResolutionPropagationContext, MetadataContext metadataContext, MetadataKey metadataKey) {
        Optional<RouterOutputMetadataContext> routerOutputMetadataContext = typeResolutionPropagationContext.getRouterOutputMetadataContext();
        if (!routerOutputMetadataContext.isPresent()) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("Cannot resolve scope input metadata without a scope output metadata context").onComponent()});
        }
        MetadataResult routerInputMetadata = this.mediator.getRouterInputMetadata(metadataContext, metadataKey, routerOutputMetadataContext.get().getRouterInputMessageType(), typeResolutionPropagationContext.getPropagatedParameterTypeResolver());
        if (routerInputMetadata.isSuccess()) {
            typeResolutionPropagationContext.setRouterInnerChainInput((RouterInputMetadataDescriptor)routerInputMetadata.get());
        }
        return routerInputMetadata;
    }

    private MetadataResult<ComponentMetadataTypesDescriptor> collectMetadata(MetadataResult<? extends BaseInputMetadataDescriptor> inputMetadataResult, MetadataResult<OutputMetadataDescriptor> outputMetadataResult, ComponentMetadataTypesDescriptor overrideTypesDescriptor) {
        if (inputMetadataResult.isSuccess() && (outputMetadataResult == null || outputMetadataResult.isSuccess())) {
            ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder().keepNonDynamicMetadata(true).withInputMetadataDescriptor((BaseInputMetadataDescriptor)inputMetadataResult.get());
            if (outputMetadataResult != null) {
                builder.withOutputMetadataDescriptor((OutputMetadataDescriptor)outputMetadataResult.get());
            }
            return MetadataResult.success((Object)this.mergeDescriptors(builder.build(), overrideTypesDescriptor));
        }
        ArrayList failures = new ArrayList(inputMetadataResult.getFailures());
        if (outputMetadataResult != null) {
            failures.addAll(outputMetadataResult.getFailures());
        }
        return MetadataResult.failure(failures);
    }

    private ComponentMetadataTypesDescriptor mergeDescriptors(ComponentMetadataTypesDescriptor withoutOverrides, ComponentMetadataTypesDescriptor overrides) {
        ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder builder = ComponentMetadataTypesDescriptor.builder();
        builder.keepNonDynamicMetadata(true);
        builder.withInputMetadataDescriptor(this.mergeInputs(withoutOverrides.getInputMetadata(), overrides.getInputMetadata()));
        builder.withOutputMetadataDescriptor(this.mergeOutputs(withoutOverrides.getOutputMetadata(), withoutOverrides.getOutputAttributesMetadata(), overrides.getOutputMetadata(), overrides.getOutputAttributesMetadata()));
        return builder.build();
    }

    private OutputMetadataDescriptor mergeOutputs(Optional<MetadataType> outputWithoutOverride, Optional<MetadataType> attributesWithoutOverride, Optional<MetadataType> outputOverride, Optional<MetadataType> attributesOverride) {
        OutputMetadataDescriptor.OutputMetadataDescriptorBuilder builder = OutputMetadataDescriptor.builder();
        builder.withReturnType(outputOverride.orElse(outputWithoutOverride.orElse(null)));
        builder.withAttributesType(attributesOverride.orElse(attributesWithoutOverride.orElse(null)));
        return builder.build();
    }

    private InputMetadataDescriptor mergeInputs(Map<String, MetadataType> withoutOverrides, Map<String, MetadataType> overrides) {
        InputMetadataDescriptor.InputMetadataDescriptorBuilder builder = InputMetadataDescriptor.builder();
        HashMap<String, MetadataType> merged = new HashMap<String, MetadataType>(withoutOverrides);
        merged.putAll(overrides);
        merged.forEach((name, metadataType) -> {
            ParameterMetadataDescriptor descriptor = ParameterMetadataDescriptor.builder((String)name).withType(metadataType).build();
            builder.withParameter(name, descriptor);
        });
        return builder.build();
    }

    private MetadataContext createMetadataContext(Optional<ConfigurationHandler> configurationHandler, Optional<ScopeOutputMetadataContext> scopeOutputMetadataContext, Optional<RouterOutputMetadataContext> routerOutputMetadataContext) {
        Optional<MetadataCacheId> configId = configurationHandler.flatMap(ch -> this.mule.getConfigIdGenerator().getConfigMetadataCacheId(ch.getName(), false));
        MetadataStorageToCacheAdapter metadataCacheAdapter = new MetadataStorageToCacheAdapter(this.metadataStorage, configId);
        return this.extensionDesignTimeResolversFactory.createMetadataContext(() -> MuleFrameworkUtils.resolveConfiguration(configurationHandler), this.wrapConnectionManager(), (MetadataCache)metadataCacheAdapter, this.typeLoader, scopeOutputMetadataContext, routerOutputMetadataContext);
    }

    private ConnectionManager wrapConnectionManager() {
        if (this.offlineMode) {
            return new OfflineConnectionManager();
        }
        return this.mule.getConnectionManager();
    }

    private MetadataContext createMetadataContext(Optional<ConfigurationHandler> configurationHandler) {
        return this.createMetadataContext(configurationHandler, Optional.empty(), Optional.empty());
    }

    private <T extends ComponentModel> void validateParameterization(ComponentParameterization<T> parameterization) {
        if (parameterization.getModel() != this.componentModel) {
            throw new IllegalArgumentException("Supplied parameterization points to a ComponentModel different than the one supplied upon creation of this session");
        }
    }

    public void close() {
        this.closer.close();
    }

    @FunctionalInterface
    private static interface MetadataResultSupplier<R>
    extends Supplier<MetadataResult<R>> {
        @Override
        default public MetadataResult<R> get() {
            try {
                return this.doGet();
            }
            catch (ConnectionException | MetadataResolvingException e) {
                throw new MuleRuntimeException(e);
            }
        }

        public MetadataResult<R> doGet() throws MetadataResolvingException, ConnectionException;
    }
}

