/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;

public class ExpressionsTypeResolver {
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final TypeBindings typeBindings;
    private final ErrorsRecorder errorsRecorder = new ErrorsRecorder();

    public ExpressionsTypeResolver(ExpressionLanguageMetadataService expressionLanguageMetadataService, TypeBindings typeBindings) {
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.typeBindings = typeBindings;
    }

    public MetadataType getOutputType(String expression) {
        return this.expressionLanguageMetadataService.getOutputType(this.typeBindings, expression, (ExpressionLanguageMetadataService.MessageCallback)this.errorsRecorder);
    }

    public Optional<MetadataFailure> getFailure() {
        if (this.errorsRecorder.getErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(MetadataFailure.Builder.newFailure().withMessage(String.join((CharSequence)"; ", this.errorsRecorder.getErrors())).withFailureCode(FailureCode.NO_DYNAMIC_METADATA_AVAILABLE).onComponent());
    }

    private static class ErrorsRecorder
    implements ExpressionLanguageMetadataService.MessageCallback {
        private final List<String> errors = new ArrayList<String>();

        private ErrorsRecorder() {
        }

        public void warning(String s, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
        }

        public void error(String s, ExpressionLanguageMetadataService.MessageLocation messageLocation) {
            this.errors.add(s);
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }
}

